/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.client.renderer;

import net.mcreator.deepborn.client.model.ModelScorpion;
import net.mcreator.deepborn.client.model.animations.ScorpionAnimation;
import net.mcreator.deepborn.entity.ScorpionEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ScorpionRenderer
extends MobRenderer<ScorpionEntity, LivingEntityRenderState, ModelScorpion> {
    private ScorpionEntity entity = null;

    public ScorpionRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelScorpion.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(ScorpionEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"deepborn:textures/entities/scorpion.png");
    }

    private static final class AnimatedModel
    extends ModelScorpion {
        private ScorpionEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(ScorpionEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animateWalk(ScorpionAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 1.0f);
            this.animate(this.entity.animationState1, ScorpionAnimation.sting, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

