/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.country.init;

import net.mcreator.country.entity.GermanyEntity;
import net.mcreator.country.entity.OmskBirdEntity;
import net.mcreator.country.entity.PolandEntity;
import net.mcreator.country.entity.ReichtangleEntity;
import net.mcreator.country.entity.ReichtangleMinionEntity;
import net.mcreator.country.entity.RussiaEntity;
import net.mcreator.country.entity.UKEntity;
import net.mcreator.country.entity.USAEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CountryModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"country");
    public static final DeferredHolder<EntityType<?>, EntityType<PolandEntity>> POLAND = CountryModEntities.register("poland", EntityType.Builder.of(PolandEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<GermanyEntity>> GERMANY = CountryModEntities.register("germany", EntityType.Builder.of(GermanyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ReichtangleEntity>> REICHTANGLE = CountryModEntities.register("reichtangle", EntityType.Builder.of(ReichtangleEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<OmskBirdEntity>> OMSK_BIRD = CountryModEntities.register("omsk_bird", EntityType.Builder.of(OmskBirdEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<UKEntity>> UK = CountryModEntities.register("uk", EntityType.Builder.of(UKEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<USAEntity>> USA = CountryModEntities.register("usa", EntityType.Builder.of(USAEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RussiaEntity>> RUSSIA = CountryModEntities.register("russia", EntityType.Builder.of(RussiaEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ReichtangleMinionEntity>> REICHTANGLE_MINION = CountryModEntities.register("reichtangle_minion", EntityType.Builder.of(ReichtangleMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"country", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        PolandEntity.init(event);
        GermanyEntity.init(event);
        ReichtangleEntity.init(event);
        OmskBirdEntity.init(event);
        UKEntity.init(event);
        USAEntity.init(event);
        RussiaEntity.init(event);
        ReichtangleMinionEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)POLAND.get(), PolandEntity.createAttributes().build());
        event.put((EntityType)GERMANY.get(), GermanyEntity.createAttributes().build());
        event.put((EntityType)REICHTANGLE.get(), ReichtangleEntity.createAttributes().build());
        event.put((EntityType)OMSK_BIRD.get(), OmskBirdEntity.createAttributes().build());
        event.put((EntityType)UK.get(), UKEntity.createAttributes().build());
        event.put((EntityType)USA.get(), USAEntity.createAttributes().build());
        event.put((EntityType)RUSSIA.get(), RussiaEntity.createAttributes().build());
        event.put((EntityType)REICHTANGLE_MINION.get(), ReichtangleMinionEntity.createAttributes().build());
    }
}

