/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.country.block;

import net.mcreator.country.procedures.SuperFlowerOnRandomClientDisplayTickProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SuperFlowerBlock
extends FlowerBlock {
    public SuperFlowerBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.DAMAGE_RESISTANCE, 100.0f, properties.mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().lightLevel(s -> 4).noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        SuperFlowerOnRandomClientDisplayTickProcedure.execute((Entity)Minecraft.getInstance().player);
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        SuperFlowerOnRandomClientDisplayTickProcedure.execute(entity);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        SuperFlowerOnRandomClientDisplayTickProcedure.execute(entity);
    }
}

