/*
 * Decompiled with CFR 0.152.
 */
package net.hidingfox.mice.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class Modelmouse
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mice", (String)"modelmouse"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart rearleftfoot;
    public final ModelPart rearrightfoot;
    public final ModelPart frontleftfoot;
    public final ModelPart frontrightfoot;
    public final ModelPart tail;

    public Modelmouse(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.torso = this.body.getChild("torso");
        this.rearleftfoot = this.torso.getChild("rearleftfoot");
        this.rearrightfoot = this.torso.getChild("rearrightfoot");
        this.frontleftfoot = this.torso.getChild("frontleftfoot");
        this.frontrightfoot = this.torso.getChild("frontrightfoot");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)3.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 0).addBox(-0.5f, -0.9f, -1.4f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-1.5f, (float)-7.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(10, 0).addBox(-1.5f, -1.5f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6358f, (float)-1.6222f, (float)0.7897f, (float)-0.3491f, (float)0.3491f, (float)-0.3491f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(10, 0).addBox(-1.5f, -1.5f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5642f, (float)-1.3222f, (float)1.1897f, (float)-0.3491f, (float)-0.3491f, (float)0.3491f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 4).addBox(-1.5f, -3.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)1.0f, (float)-2.0f));
        PartDefinition rearleftfoot = torso.addOrReplaceChild("rearleftfoot", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)0.0f, (float)2.0f));
        PartDefinition cube_r3 = rearleftfoot.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(7, 12).addBox(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.2f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1345f, (float)0.0f));
        PartDefinition rearrightfoot = torso.addOrReplaceChild("rearrightfoot", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)0.0f, (float)2.0f));
        PartDefinition cube_r4 = rearrightfoot.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(7, 12).addBox(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9199f, (float)0.0f));
        PartDefinition frontleftfoot = torso.addOrReplaceChild("frontleftfoot", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)0.0f, (float)-5.0f));
        PartDefinition cube_r5 = frontleftfoot.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(9, 7).addBox(0.0f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition frontrightfoot = torso.addOrReplaceChild("frontrightfoot", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)0.0f, (float)-5.0f));
        PartDefinition cube_r6 = frontrightfoot.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(9, 7).addBox(0.0f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(8, 4).addBox(-0.5f, 1.02f, 1.3f, 1.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-0.5f, (float)1.5f));
        PartDefinition cube_r7 = tail.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(7, 3).addBox(0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)-1.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }
}

