/*
 * Decompiled with CFR 0.152.
 */
package net.hidingfox.mice.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hidingfox.mice.client.model.Modeljerboa;
import net.hidingfox.mice.client.model.animations.jerboaAnimation;
import net.hidingfox.mice.entity.JerboaEntity;
import net.hidingfox.mice.procedures.MouseModelVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class JerboaRenderer
extends MobRenderer<JerboaEntity, LivingEntityRenderState, Modeljerboa> {
    private JerboaEntity entity = null;

    public JerboaRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeljerboa.LAYER_LOCATION)), 0.3f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(JerboaEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"mice:textures/entities/jerboatexture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        float scale = (float)MouseModelVisualScaleProcedure.execute((Entity)this.entity);
        poseStack.scale(scale, scale, scale);
    }

    private static final class AnimatedModel
    extends Modeljerboa {
        private JerboaEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(JerboaEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animateWalk(jerboaAnimation.walking, state.walkAnimationPos, state.walkAnimationSpeed, 7.0f, 4.0f);
            this.animate(this.entity.animationState1, jerboaAnimation.sprinting, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

