/*
 * Decompiled with CFR 0.152.
 */
package net.hidingfox.mice.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hidingfox.mice.client.model.Modelmouse;
import net.hidingfox.mice.client.model.animations.mouseAnimation;
import net.hidingfox.mice.entity.MouseEntity;
import net.hidingfox.mice.procedures.MouseModelVisualScaleProcedure;
import net.hidingfox.mice.procedures.MousePlaybackConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MouseRenderer
extends MobRenderer<MouseEntity, LivingEntityRenderState, Modelmouse> {
    private MouseEntity entity = null;

    public MouseRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelmouse.LAYER_LOCATION)), 0.3f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(MouseEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"mice:textures/entities/mousetexture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        float scale = (float)MouseModelVisualScaleProcedure.execute((Entity)this.entity);
        poseStack.scale(scale, scale, scale);
    }

    private static final class AnimatedModel
    extends Modelmouse {
        private MouseEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(MouseEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (MousePlaybackConditionProcedure.execute()) {
                this.animateWalk(mouseAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 4.0f, 5.0f);
            }
            this.animate(this.entity.animationState1, mouseAnimation.run, state.ageInTicks, 4.0f);
            super.setupAnim(state);
        }
    }
}

