/*
 * Decompiled with CFR 0.152.
 */
package net.hidingfox.mice.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.hidingfox.mice.client.model.Modelwoollymouse;
import net.hidingfox.mice.client.model.animations.woollymouseAnimation;
import net.hidingfox.mice.entity.WoollyMouseEntity;
import net.hidingfox.mice.procedures.MouseModelVisualScaleProcedure;
import net.hidingfox.mice.procedures.MousePlaybackConditionProcedure;
import net.hidingfox.mice.procedures.WoollyMouseDisplayConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class WoollyMouseRenderer
extends MobRenderer<WoollyMouseEntity, LivingEntityRenderState, Modelwoollymouse> {
    private WoollyMouseEntity entity = null;

    public WoollyMouseRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelwoollymouse.LAYER_LOCATION)), 0.3f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelwoollymouse>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"mice:textures/entities/woollymouseshearedtexture.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = WoollyMouseRenderer.this.entity.level();
                double x = WoollyMouseRenderer.this.entity.getX();
                double y = WoollyMouseRenderer.this.entity.getY();
                double z = WoollyMouseRenderer.this.entity.getZ();
                if (WoollyMouseDisplayConditionProcedure.execute((Entity)WoollyMouseRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelwoollymouse)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(WoollyMouseEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"mice:textures/entities/woollymousetexture.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        float scale = (float)MouseModelVisualScaleProcedure.execute((Entity)this.entity);
        poseStack.scale(scale, scale, scale);
    }

    private static final class AnimatedModel
    extends Modelwoollymouse {
        private WoollyMouseEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(WoollyMouseEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (MousePlaybackConditionProcedure.execute()) {
                this.animateWalk(woollymouseAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 4.0f, 5.0f);
            }
            this.animate(this.entity.animationState1, woollymouseAnimation.run, state.ageInTicks, 4.0f);
            super.setupAnim(state);
        }
    }
}

