/*
 * Decompiled with CFR 0.152.
 */
package net.hidingfox.mice.init;

import net.hidingfox.mice.entity.JerboaEntity;
import net.hidingfox.mice.entity.MouseEntity;
import net.hidingfox.mice.entity.RatEntity;
import net.hidingfox.mice.entity.WoollyMouseEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MiceModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mice");
    public static final DeferredHolder<EntityType<?>, EntityType<MouseEntity>> MOUSE = MiceModEntities.register("mouse", EntityType.Builder.of(MouseEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RatEntity>> RAT = MiceModEntities.register("rat", EntityType.Builder.of(RatEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).sized(0.3f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<JerboaEntity>> JERBOA = MiceModEntities.register("jerboa", EntityType.Builder.of(JerboaEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).sized(0.3f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<WoollyMouseEntity>> WOOLLY_MOUSE = MiceModEntities.register("woolly_mouse", EntityType.Builder.of(WoollyMouseEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mice", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MouseEntity.init(event);
        RatEntity.init(event);
        JerboaEntity.init(event);
        WoollyMouseEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MOUSE.get(), MouseEntity.createAttributes().build());
        event.put((EntityType)RAT.get(), RatEntity.createAttributes().build());
        event.put((EntityType)JERBOA.get(), JerboaEntity.createAttributes().build());
        event.put((EntityType)WOOLLY_MOUSE.get(), WoollyMouseEntity.createAttributes().build());
    }
}

