/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftupdate.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.minecraftupdate.Minecraft121UpdateMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Minecraft121UpdateModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        Minecraft121UpdateMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        Minecraft121UpdateMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Minecraft121UpdateMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.Player_enterX = message.data.Player_enterX;
                    variables.Player_enterY = message.data.Player_enterY;
                    variables.Player_enterZ = message.data.Player_enterZ;
                    variables.Boss_killer = message.data.Boss_killer;
                    variables.In_Boss = message.data.In_Boss;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double Player_enterX = 0.0;
        public double Player_enterY = 0.0;
        public double Player_enterZ = 0.0;
        public boolean Boss_killer = false;
        public boolean In_Boss = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Minecraft121UpdateMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Player_enterX", this.Player_enterX);
            nbt.m_128347_("Player_enterY", this.Player_enterY);
            nbt.m_128347_("Player_enterZ", this.Player_enterZ);
            nbt.m_128379_("Boss_killer", this.Boss_killer);
            nbt.m_128379_("In_Boss", this.In_Boss);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.Player_enterX = nbt.m_128459_("Player_enterX");
            this.Player_enterY = nbt.m_128459_("Player_enterY");
            this.Player_enterZ = nbt.m_128459_("Player_enterZ");
            this.Boss_killer = nbt.m_128471_("Boss_killer");
            this.In_Boss = nbt.m_128471_("In_Boss");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("minecraft_121_update", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "minecraft_121_update_mapvars";
        public boolean tuff_red = false;
        public boolean tuff_black = false;
        public boolean tuff_white = false;
        public boolean tuff_blue = false;
        public boolean tuff_lighrt_blue = false;
        public boolean tuff_lime = false;
        public boolean tuff_orange = false;
        public boolean tuff_magenta = false;
        public boolean brown = false;
        public boolean attack_center = false;
        public boolean center_attack_hit = false;
        public boolean center_attack_big_hit = false;
        public boolean attack_right = false;
        public boolean attack_left = false;
        public boolean spawn_entity = false;
        public boolean swing = false;
        public boolean redstoneon = false;
        public boolean player_center = false;
        public boolean player_left = false;
        public boolean player_right = false;
        public boolean attack = false;
        public boolean death = false;
        public boolean wand = false;
        public boolean hit = false;
        public double keys_used = 0.0;
        public double key_used2 = 0.0;
        public boolean traveled = false;
        public boolean spawner_spawning = false;
        public boolean boss_spawn = false;
        public double wand_countdown = 0.0;
        public double Sleep_Count = 0.0;
        public double Day_Count = 0.0;
        public double SpawnerNumber = 0.0;
        public boolean Boss = false;
        public boolean Spawner_Spawned = false;
        public boolean Boss_Death = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.tuff_red = nbt.m_128471_("tuff_red");
            this.tuff_black = nbt.m_128471_("tuff_black");
            this.tuff_white = nbt.m_128471_("tuff_white");
            this.tuff_blue = nbt.m_128471_("tuff_blue");
            this.tuff_lighrt_blue = nbt.m_128471_("tuff_lighrt_blue");
            this.tuff_lime = nbt.m_128471_("tuff_lime");
            this.tuff_orange = nbt.m_128471_("tuff_orange");
            this.tuff_magenta = nbt.m_128471_("tuff_magenta");
            this.brown = nbt.m_128471_("brown");
            this.attack_center = nbt.m_128471_("attack_center");
            this.center_attack_hit = nbt.m_128471_("center_attack_hit");
            this.center_attack_big_hit = nbt.m_128471_("center_attack_big_hit");
            this.attack_right = nbt.m_128471_("attack_right");
            this.attack_left = nbt.m_128471_("attack_left");
            this.spawn_entity = nbt.m_128471_("spawn_entity");
            this.swing = nbt.m_128471_("swing");
            this.redstoneon = nbt.m_128471_("redstoneon");
            this.player_center = nbt.m_128471_("player_center");
            this.player_left = nbt.m_128471_("player_left");
            this.player_right = nbt.m_128471_("player_right");
            this.attack = nbt.m_128471_("attack");
            this.death = nbt.m_128471_("death");
            this.wand = nbt.m_128471_("wand");
            this.hit = nbt.m_128471_("hit");
            this.keys_used = nbt.m_128459_("keys_used");
            this.key_used2 = nbt.m_128459_("key_used2");
            this.traveled = nbt.m_128471_("traveled");
            this.spawner_spawning = nbt.m_128471_("spawner_spawning");
            this.boss_spawn = nbt.m_128471_("boss_spawn");
            this.wand_countdown = nbt.m_128459_("wand_countdown");
            this.Sleep_Count = nbt.m_128459_("Sleep_Count");
            this.Day_Count = nbt.m_128459_("Day_Count");
            this.SpawnerNumber = nbt.m_128459_("SpawnerNumber");
            this.Boss = nbt.m_128471_("Boss");
            this.Spawner_Spawned = nbt.m_128471_("Spawner_Spawned");
            this.Boss_Death = nbt.m_128471_("Boss_Death");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("tuff_red", this.tuff_red);
            nbt.m_128379_("tuff_black", this.tuff_black);
            nbt.m_128379_("tuff_white", this.tuff_white);
            nbt.m_128379_("tuff_blue", this.tuff_blue);
            nbt.m_128379_("tuff_lighrt_blue", this.tuff_lighrt_blue);
            nbt.m_128379_("tuff_lime", this.tuff_lime);
            nbt.m_128379_("tuff_orange", this.tuff_orange);
            nbt.m_128379_("tuff_magenta", this.tuff_magenta);
            nbt.m_128379_("brown", this.brown);
            nbt.m_128379_("attack_center", this.attack_center);
            nbt.m_128379_("center_attack_hit", this.center_attack_hit);
            nbt.m_128379_("center_attack_big_hit", this.center_attack_big_hit);
            nbt.m_128379_("attack_right", this.attack_right);
            nbt.m_128379_("attack_left", this.attack_left);
            nbt.m_128379_("spawn_entity", this.spawn_entity);
            nbt.m_128379_("swing", this.swing);
            nbt.m_128379_("redstoneon", this.redstoneon);
            nbt.m_128379_("player_center", this.player_center);
            nbt.m_128379_("player_left", this.player_left);
            nbt.m_128379_("player_right", this.player_right);
            nbt.m_128379_("attack", this.attack);
            nbt.m_128379_("death", this.death);
            nbt.m_128379_("wand", this.wand);
            nbt.m_128379_("hit", this.hit);
            nbt.m_128347_("keys_used", this.keys_used);
            nbt.m_128347_("key_used2", this.key_used2);
            nbt.m_128379_("traveled", this.traveled);
            nbt.m_128379_("spawner_spawning", this.spawner_spawning);
            nbt.m_128379_("boss_spawn", this.boss_spawn);
            nbt.m_128347_("wand_countdown", this.wand_countdown);
            nbt.m_128347_("Sleep_Count", this.Sleep_Count);
            nbt.m_128347_("Day_Count", this.Day_Count);
            nbt.m_128347_("SpawnerNumber", this.SpawnerNumber);
            nbt.m_128379_("Boss", this.Boss);
            nbt.m_128379_("Spawner_Spawned", this.Spawner_Spawned);
            nbt.m_128379_("Boss_Death", this.Boss_Death);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                Minecraft121UpdateMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "minecraft_121_update_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                Minecraft121UpdateMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.Player_enterX = original.Player_enterX;
            clone.Player_enterY = original.Player_enterY;
            clone.Player_enterZ = original.Player_enterZ;
            clone.Boss_killer = original.Boss_killer;
            if (!event.isWasDeath()) {
                clone.In_Boss = original.In_Boss;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    Minecraft121UpdateMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    Minecraft121UpdateMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                Minecraft121UpdateMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

