/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theboimeupdate.world.features.treedecorators;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FallforestLeaveDecorator
extends LeaveVineDecorator {
    public static Codec<LeaveVineDecorator> CODEC = Codec.unit(FallforestLeaveDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, new ResourceLocation("the_boime_update:fallforest_tree_leave_decorator"), () -> DECORATOR_TYPE);
    }

    public FallforestLeaveDecorator() {
        super(0.25f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.leaves().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.west())) {
                FallforestLeaveDecorator.addVine(pos, Direction.WEST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.east())) {
                FallforestLeaveDecorator.addVine(pos, Direction.EAST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.north())) {
                FallforestLeaveDecorator.addVine(pos, Direction.NORTH, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.south())) {
                FallforestLeaveDecorator.addVine(pos, Direction.SOUTH, context);
            }
        });
    }

    private static void addVine(BlockPos pos, Direction direction, TreeDecorator.Context context) {
        context.setBlock(pos, Blocks.VINE.defaultBlockState());
        BlockPos blockpos = pos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            context.setBlock(blockpos, FallforestLeaveDecorator.oriented(Blocks.VINE.defaultBlockState(), direction));
            blockpos = blockpos.below();
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.getBlock().rotate(blockstate, Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.getBlock().rotate(blockstate, Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.getBlock().rotate(blockstate, Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

