/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.anarchist.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelexploiter<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"anarchist", (String)"modelexploiter"), "main");
    public final ModelPart waist;
    public final ModelPart Body;
    public final ModelPart head;
    public final ModelPart nose;
    public final ModelPart LeftLeg;
    public final ModelPart RightLeg;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;

    public Modelexploiter(ModelPart root) {
        this.waist = root.getChild("waist");
        this.Body = this.waist.getChild("Body");
        this.head = root.getChild("head");
        this.nose = this.head.getChild("nose");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition waist = partdefinition.addOrReplaceChild("waist", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition Body = waist.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(28, 50).addBox(-4.0f, -24.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-4.0f, -24.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(28, 32).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(16, 56).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 56).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 56).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(56, 50).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)2.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.1745f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(56, 50).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).addBox(-9.0f, 8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(-2.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.5f, (float)0.0f, (float)-3.0543f, (float)0.0f, (float)0.2182f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.waist.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

