/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.missing.init;

import net.mcreator.missing.entity.HimEntity;
import net.mcreator.missing.entity.NotEntity;
import net.mcreator.missing.entity.TEXTUREEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MissingModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"missing");
    public static final DeferredHolder<EntityType<?>, EntityType<TEXTUREEntity>> TEXTURE = MissingModEntities.register("texture", EntityType.Builder.of(TEXTUREEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<HimEntity>> HIM = MissingModEntities.register("him", EntityType.Builder.of(HimEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<NotEntity>> NOT = MissingModEntities.register("not", EntityType.Builder.of(NotEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        TEXTUREEntity.init(event);
        HimEntity.init(event);
        NotEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)TEXTURE.get(), TEXTUREEntity.createAttributes().build());
        event.put((EntityType)HIM.get(), HimEntity.createAttributes().build());
        event.put((EntityType)NOT.get(), NotEntity.createAttributes().build());
    }
}

