/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moo.block;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.mcreator.moo.world.teleporter.OttersyoPortalShape;
import net.mcreator.moo.world.teleporter.OttersyoTeleporter;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public class OttersyoPortalBlock
extends NetherPortalBlock {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void portalSpawn(Level world, BlockPos pos) {
        Optional<OttersyoPortalShape> optional = OttersyoPortalShape.findEmptyPortalShape((LevelAccessor)world, pos, Direction.Axis.X);
        if (optional.isPresent()) {
            optional.get().createPortalBlocks((LevelAccessor)world);
        }
    }

    public OttersyoPortalBlock(BlockBehaviour.Properties properties) {
        super(properties.noCollission().randomTicks().pushReaction(PushReaction.BLOCK).strength(-1.0f).sound(SoundType.GLASS).lightLevel(s -> 0).noLootTable());
    }

    private OttersyoTeleporter getTeleporter(ServerLevel level) {
        return new OttersyoTeleporter(level);
    }

    protected BlockState updateShape(BlockState p_54928_, LevelReader p_374413_, ScheduledTickAccess p_374339_, BlockPos p_54932_, Direction p_54929_, BlockPos p_54933_, BlockState p_54930_, RandomSource p_374242_) {
        Direction.Axis direction$axis = p_54929_.getAxis();
        Direction.Axis direction$axis1 = (Direction.Axis)p_54928_.getValue((Property)AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.isHorizontal();
        return !flag && !p_54930_.is((Block)this) && !OttersyoPortalShape.findAnyShape((BlockGetter)p_374413_, p_54932_, direction$axis1).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(p_54928_, p_374413_, p_374339_, p_54932_, p_54929_, p_54933_, p_54930_, p_374242_);
    }

    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel p_350444_, Entity p_350334_, BlockPos p_350764_) {
        ResourceKey resourcekey = p_350444_.dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"moo:ottersyo")) ? Level.OVERWORLD : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"moo:ottersyo"));
        ServerLevel serverlevel = p_350444_.getServer().getLevel(resourcekey);
        if (serverlevel == null) {
            return null;
        }
        boolean flag = serverlevel.dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"moo:ottersyo"));
        WorldBorder worldborder = serverlevel.getWorldBorder();
        double d0 = DimensionType.getTeleportationScale((DimensionType)p_350444_.dimensionType(), (DimensionType)serverlevel.dimensionType());
        BlockPos blockpos = worldborder.clampToBounds(p_350334_.getX() * d0, p_350334_.getY(), p_350334_.getZ() * d0);
        return this.getExitPortal(serverlevel, p_350334_, p_350764_, blockpos, flag, worldborder);
    }

    @Nullable
    private TeleportTransition getExitPortal(ServerLevel p_350564_, Entity p_350493_, BlockPos p_350379_, BlockPos p_350747_, boolean p_350326_, WorldBorder p_350718_) {
        TeleportTransition.PostTeleportTransition teleporttransition$postteleporttransition;
        BlockUtil.FoundRectangle blockutil$foundrectangle;
        Optional<BlockPos> optional = this.getTeleporter(p_350564_).findClosestPortalPosition(p_350747_, p_350326_, p_350718_);
        if (optional.isPresent()) {
            BlockPos blockpos = optional.get();
            BlockState blockstate = p_350564_.getBlockState(blockpos);
            blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_351970_ -> p_350564_.getBlockState(p_351970_) == blockstate);
            teleporttransition$postteleporttransition = TeleportTransition.PLAY_PORTAL_SOUND.then(p_351967_ -> p_351967_.placePortalTicket(blockpos));
        } else {
            Direction.Axis direction$axis = p_350493_.level().getBlockState(p_350379_).getOptionalValue((Property)AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> optional1 = this.getTeleporter(p_350564_).createPortal(p_350747_, direction$axis);
            if (optional1.isEmpty()) {
                LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            blockutil$foundrectangle = optional1.get();
            teleporttransition$postteleporttransition = TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET);
        }
        return OttersyoPortalBlock.getDimensionTransitionFromExit(p_350493_, p_350379_, blockutil$foundrectangle, p_350564_, teleporttransition$postteleporttransition);
    }

    private static TeleportTransition getDimensionTransitionFromExit(Entity p_350906_, BlockPos p_350376_, BlockUtil.FoundRectangle p_350428_, ServerLevel p_350928_, TeleportTransition.PostTeleportTransition p_379530_) {
        Vec3 vec3;
        Direction.Axis direction$axis;
        BlockState blockstate = p_350906_.level().getBlockState(p_350376_);
        if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            direction$axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)p_350376_, (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_351016_ -> p_350906_.level().getBlockState(p_351016_) == blockstate);
            vec3 = p_350906_.getRelativePortalPosition(direction$axis, blockutil$foundrectangle);
        } else {
            direction$axis = Direction.Axis.X;
            vec3 = new Vec3(0.5, 0.0, 0.0);
        }
        return OttersyoPortalBlock.createDimensionTransition(p_350928_, p_350428_, direction$axis, vec3, p_350906_, p_379530_);
    }

    private static TeleportTransition createDimensionTransition(ServerLevel p_350955_, BlockUtil.FoundRectangle p_350865_, Direction.Axis p_351013_, Vec3 p_351020_, Entity p_350578_, TeleportTransition.PostTeleportTransition p_379531_) {
        BlockPos blockpos = p_350865_.minCorner;
        BlockState blockstate = p_350955_.getBlockState(blockpos);
        Direction.Axis direction$axis = blockstate.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double d0 = p_350865_.axis1Size;
        double d1 = p_350865_.axis2Size;
        EntityDimensions entitydimensions = p_350578_.getDimensions(p_350578_.getPose());
        int i = p_351013_ == direction$axis ? 0 : 90;
        double d2 = (double)entitydimensions.width() / 2.0 + (d0 - (double)entitydimensions.width()) * p_351020_.x();
        double d3 = (d1 - (double)entitydimensions.height()) * p_351020_.y();
        double d4 = 0.5 + p_351020_.z();
        boolean flag = direction$axis == Direction.Axis.X;
        Vec3 vec3 = new Vec3((double)blockpos.getX() + (flag ? d2 : d4), (double)blockpos.getY() + d3, (double)blockpos.getZ() + (flag ? d4 : d2));
        Vec3 vec31 = OttersyoPortalShape.findCollisionFreePosition(vec3, p_350955_, p_350578_, entitydimensions);
        return new TeleportTransition(p_350955_, vec31, Vec3.ZERO, (float)i, 0.0f, Relative.union((Set[])new Set[]{Relative.DELTA, Relative.ROTATION}), p_379531_);
    }

    public int getPortalTransitionTime(ServerLevel world, Entity entity) {
        return 0;
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.NONE;
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            double px = (float)pos.getX() + random.nextFloat();
            double py = (float)pos.getY() + random.nextFloat();
            double pz = (float)pos.getZ() + random.nextFloat();
            double vx = ((double)random.nextFloat() - 0.5) / 2.0;
            double vy = ((double)random.nextFloat() - 0.5) / 2.0;
            double vz = ((double)random.nextFloat() - 0.5) / 2.0;
            int j = random.nextInt(4) - 1;
            if (world.getBlockState(pos.west()).getBlock() != this && world.getBlockState(pos.east()).getBlock() != this) {
                px = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                vx = random.nextFloat() * 2.0f * (float)j;
            } else {
                pz = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                vz = random.nextFloat() * 2.0f * (float)j;
            }
            world.addParticle((ParticleOptions)ParticleTypes.CRIT, px, py, pz, vx, vy, vz);
        }
        if (random.nextInt(110) == 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.portal.ambient")), SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
    }
}

