/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moo.fluid;

import net.mcreator.moo.init.MooModBlocks;
import net.mcreator.moo.init.MooModFluidTypes;
import net.mcreator.moo.init.MooModFluids;
import net.mcreator.moo.init.MooModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class LiquidSlimeFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)MooModFluidTypes.LIQUID_SLIME_TYPE.get(), () -> (Fluid)MooModFluids.LIQUID_SLIME.get(), () -> (Fluid)MooModFluids.FLOWING_LIQUID_SLIME.get()).explosionResistance(100.0f).bucket(() -> (Item)MooModItems.LIQUID_SLIME_BUCKET.get()).block(() -> (LiquidBlock)MooModBlocks.LIQUID_SLIME.get());

    private LiquidSlimeFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.ASH;
    }

    public static class Flowing
    extends LiquidSlimeFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends LiquidSlimeFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

