/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moo.fluid;

import net.mcreator.moo.init.MooModBlocks;
import net.mcreator.moo.init.MooModFluidTypes;
import net.mcreator.moo.init.MooModFluids;
import net.mcreator.moo.init.MooModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class OilFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)MooModFluidTypes.OIL_TYPE.get(), () -> (Fluid)MooModFluids.OIL.get(), () -> (Fluid)MooModFluids.FLOWING_OIL.get()).explosionResistance(100.0f).bucket(() -> (Item)MooModItems.OIL_BUCKET.get()).block(() -> (LiquidBlock)MooModBlocks.OIL.get());

    private OilFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.BUBBLE_POP;
    }

    public static class Flowing
    extends OilFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends OilFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

