/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dimensionofthetaiga.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;

public class TrepiliumFluidFluidType
extends FluidType {
    public TrepiliumFluidFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).motionScale(0.007).canConvertToSource(true).rarity(Rarity.UNCOMMON).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.bucket.empty"))).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("dimension_of_the_taiga:block/water");
            private static final ResourceLocation FLOWING_TEXTURE = new ResourceLocation("dimension_of_the_taiga:block/water");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                Entity entity = camera.m_90592_();
                Level world = entity.m_9236_();
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)Math.min(48.0f, renderDistance));
            }

            public int getTintColor() {
                return -16448205;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
                return ((Biome)Minecraft.m_91087_().f_91073_.m_204166_(pos).m_203334_()).m_47561_() | 0xFF000000;
            }
        });
    }
}

