/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.poca.network;

import java.util.function.Supplier;
import net.mcreator.poca.PocaMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PocaModVariables {
    public static double tickHot = 0.0;
    public static double Termo = 0.0;
    public static boolean stable = false;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PocaMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        PocaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.distance1X = message.data.distance1X;
                    variables.distance1Y = message.data.distance1Y;
                    variables.distance1Z = message.data.distance1Z;
                    variables.distance2X = message.data.distance2X;
                    variables.distance2Y = message.data.distance2Y;
                    variables.distance2Z = message.data.distance2Z;
                    variables.distance1 = message.data.distance1;
                    variables.distance2 = message.data.distance2;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double distance1X = 0.0;
        public double distance1Y = 0.0;
        public double distance1Z = 0.0;
        public double distance2X = 0.0;
        public double distance2Y = 0.0;
        public double distance2Z = 0.0;
        public boolean distance1 = false;
        public boolean distance2 = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PocaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("distance1X", this.distance1X);
            nbt.m_128347_("distance1Y", this.distance1Y);
            nbt.m_128347_("distance1Z", this.distance1Z);
            nbt.m_128347_("distance2X", this.distance2X);
            nbt.m_128347_("distance2Y", this.distance2Y);
            nbt.m_128347_("distance2Z", this.distance2Z);
            nbt.m_128379_("distance1", this.distance1);
            nbt.m_128379_("distance2", this.distance2);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.distance1X = nbt.m_128459_("distance1X");
            this.distance1Y = nbt.m_128459_("distance1Y");
            this.distance1Z = nbt.m_128459_("distance1Z");
            this.distance2X = nbt.m_128459_("distance2X");
            this.distance2Y = nbt.m_128459_("distance2Y");
            this.distance2Z = nbt.m_128459_("distance2Z");
            this.distance1 = nbt.m_128471_("distance1");
            this.distance2 = nbt.m_128471_("distance2");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("poca", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "poca_mapvars";
        public double z5 = 0.0;
        public double z4 = 0.0;
        public double z3 = 0.0;
        public double z2 = 0.0;
        public double z1 = 0.0;
        public double y5 = 0.0;
        public double y4 = 0.0;
        public double y3 = 0.0;
        public double y2 = 0.0;
        public double y1 = 0.0;
        public double x5 = 0.0;
        public double x4 = 0.0;
        public double x3 = 0.0;
        public double x2 = 0.0;
        public double x1 = 0.0;
        public double tickrandom = 0.0;
        public double spawnZ = 0.0;
        public double spawnY = 0.0;
        public double spawnX = 0.0;
        public double spawnerTime = 10.0;
        public double spawnerCooldown = 0.0;
        public double n4 = 0.0;
        public double n3 = 0.0;
        public double n2 = 0.0;
        public double n1 = 0.0;
        public double e6 = 0.0;
        public double e5 = 0.0;
        public double e4 = 0.0;
        public double e3 = 0.0;
        public double e2 = 0.0;
        public double e1 = 0.0;
        public String CrystalCharge = "";
        public double boom = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.z5 = nbt.m_128459_("z5");
            this.z4 = nbt.m_128459_("z4");
            this.z3 = nbt.m_128459_("z3");
            this.z2 = nbt.m_128459_("z2");
            this.z1 = nbt.m_128459_("z1");
            this.y5 = nbt.m_128459_("y5");
            this.y4 = nbt.m_128459_("y4");
            this.y3 = nbt.m_128459_("y3");
            this.y2 = nbt.m_128459_("y2");
            this.y1 = nbt.m_128459_("y1");
            this.x5 = nbt.m_128459_("x5");
            this.x4 = nbt.m_128459_("x4");
            this.x3 = nbt.m_128459_("x3");
            this.x2 = nbt.m_128459_("x2");
            this.x1 = nbt.m_128459_("x1");
            this.tickrandom = nbt.m_128459_("tickrandom");
            this.spawnZ = nbt.m_128459_("spawnZ");
            this.spawnY = nbt.m_128459_("spawnY");
            this.spawnX = nbt.m_128459_("spawnX");
            this.spawnerTime = nbt.m_128459_("spawnerTime");
            this.spawnerCooldown = nbt.m_128459_("spawnerCooldown");
            this.n4 = nbt.m_128459_("n4");
            this.n3 = nbt.m_128459_("n3");
            this.n2 = nbt.m_128459_("n2");
            this.n1 = nbt.m_128459_("n1");
            this.e6 = nbt.m_128459_("e6");
            this.e5 = nbt.m_128459_("e5");
            this.e4 = nbt.m_128459_("e4");
            this.e3 = nbt.m_128459_("e3");
            this.e2 = nbt.m_128459_("e2");
            this.e1 = nbt.m_128459_("e1");
            this.CrystalCharge = nbt.m_128461_("CrystalCharge");
            this.boom = nbt.m_128459_("boom");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("z5", this.z5);
            nbt.m_128347_("z4", this.z4);
            nbt.m_128347_("z3", this.z3);
            nbt.m_128347_("z2", this.z2);
            nbt.m_128347_("z1", this.z1);
            nbt.m_128347_("y5", this.y5);
            nbt.m_128347_("y4", this.y4);
            nbt.m_128347_("y3", this.y3);
            nbt.m_128347_("y2", this.y2);
            nbt.m_128347_("y1", this.y1);
            nbt.m_128347_("x5", this.x5);
            nbt.m_128347_("x4", this.x4);
            nbt.m_128347_("x3", this.x3);
            nbt.m_128347_("x2", this.x2);
            nbt.m_128347_("x1", this.x1);
            nbt.m_128347_("tickrandom", this.tickrandom);
            nbt.m_128347_("spawnZ", this.spawnZ);
            nbt.m_128347_("spawnY", this.spawnY);
            nbt.m_128347_("spawnX", this.spawnX);
            nbt.m_128347_("spawnerTime", this.spawnerTime);
            nbt.m_128347_("spawnerCooldown", this.spawnerCooldown);
            nbt.m_128347_("n4", this.n4);
            nbt.m_128347_("n3", this.n3);
            nbt.m_128347_("n2", this.n2);
            nbt.m_128347_("n1", this.n1);
            nbt.m_128347_("e6", this.e6);
            nbt.m_128347_("e5", this.e5);
            nbt.m_128347_("e4", this.e4);
            nbt.m_128347_("e3", this.e3);
            nbt.m_128347_("e2", this.e2);
            nbt.m_128347_("e1", this.e1);
            nbt.m_128359_("CrystalCharge", this.CrystalCharge);
            nbt.m_128347_("boom", this.boom);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                PocaMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "poca_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                PocaMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.distance1X = original.distance1X;
            clone.distance1Y = original.distance1Y;
            clone.distance1Z = original.distance1Z;
            clone.distance2X = original.distance2X;
            clone.distance2Y = original.distance2Y;
            clone.distance2Z = original.distance2Z;
            clone.distance1 = original.distance1;
            clone.distance2 = original.distance2;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    PocaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    PocaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                PocaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

