
/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.the_reza_mod.init;

import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;

import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Entity;

import net.mcreator.the_reza_mod.entity.WaterSlimeEntity;
import net.mcreator.the_reza_mod.entity.SlifiesEntity;
import net.mcreator.the_reza_mod.entity.RainbowSlimeEntity;
import net.mcreator.the_reza_mod.entity.PointySlimeEntity;
import net.mcreator.the_reza_mod.entity.PinkSlimeEntity;
import net.mcreator.the_reza_mod.entity.MimicSlimeEntity;
import net.mcreator.the_reza_mod.entity.HappySlimeEntity;
import net.mcreator.the_reza_mod.entity.FlyimeEntity;
import net.mcreator.the_reza_mod.entity.FireSlimeEntity;
import net.mcreator.the_reza_mod.TheRezaModMod;

@Mod.EventBusSubscriber(bus = Mod.EventBusSubscriber.Bus.MOD)
public class TheRezaModModEntities {
	public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create(ForgeRegistries.ENTITY_TYPES, TheRezaModMod.MODID);
	public static final RegistryObject<EntityType<PointySlimeEntity>> POINTY_SLIME = register("pointy_slime",
			EntityType.Builder.<PointySlimeEntity>of(PointySlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PointySlimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<WaterSlimeEntity>> WATER_SLIME = register("water_slime",
			EntityType.Builder.<WaterSlimeEntity>of(WaterSlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(WaterSlimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<FireSlimeEntity>> FIRE_SLIME = register("fire_slime",
			EntityType.Builder.<FireSlimeEntity>of(FireSlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FireSlimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<HappySlimeEntity>> HAPPY_SLIME = register("happy_slime",
			EntityType.Builder.<HappySlimeEntity>of(HappySlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(HappySlimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<PinkSlimeEntity>> PINK_SLIME = register("pink_slime",
			EntityType.Builder.<PinkSlimeEntity>of(PinkSlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PinkSlimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<FlyimeEntity>> FLYIME = register("flyime",
			EntityType.Builder.<FlyimeEntity>of(FlyimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FlyimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<SlifiesEntity>> SLIFIES = register("slifies",
			EntityType.Builder.<SlifiesEntity>of(SlifiesEntity::new, MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SlifiesEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<RainbowSlimeEntity>> RAINBOW_SLIME = register("rainbow_slime",
			EntityType.Builder.<RainbowSlimeEntity>of(RainbowSlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RainbowSlimeEntity::new)

					.sized(1f, 1f));
	public static final RegistryObject<EntityType<MimicSlimeEntity>> MIMIC_SLIME = register("mimic_slime",
			EntityType.Builder.<MimicSlimeEntity>of(MimicSlimeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MimicSlimeEntity::new)

					.sized(1f, 1f));

	// Start of user code block custom entities
	// End of user code block custom entities
	private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
		return REGISTRY.register(registryname, () -> (EntityType<T>) entityTypeBuilder.build(registryname));
	}

	@SubscribeEvent
	public static void init(FMLCommonSetupEvent event) {
		event.enqueueWork(() -> {
			PointySlimeEntity.init();
			WaterSlimeEntity.init();
			FireSlimeEntity.init();
			HappySlimeEntity.init();
			PinkSlimeEntity.init();
			FlyimeEntity.init();
			SlifiesEntity.init();
			RainbowSlimeEntity.init();
			MimicSlimeEntity.init();
		});
	}

	@SubscribeEvent
	public static void registerAttributes(EntityAttributeCreationEvent event) {
		event.put(POINTY_SLIME.get(), PointySlimeEntity.createAttributes().build());
		event.put(WATER_SLIME.get(), WaterSlimeEntity.createAttributes().build());
		event.put(FIRE_SLIME.get(), FireSlimeEntity.createAttributes().build());
		event.put(HAPPY_SLIME.get(), HappySlimeEntity.createAttributes().build());
		event.put(PINK_SLIME.get(), PinkSlimeEntity.createAttributes().build());
		event.put(FLYIME.get(), FlyimeEntity.createAttributes().build());
		event.put(SLIFIES.get(), SlifiesEntity.createAttributes().build());
		event.put(RAINBOW_SLIME.get(), RainbowSlimeEntity.createAttributes().build());
		event.put(MIMIC_SLIME.get(), MimicSlimeEntity.createAttributes().build());
	}
}
