/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.healingmod.entity;

import java.util.List;
import java.util.Random;
import java.util.Set;
import net.mcreator.healingmod.entity.DamageManEntity;
import net.mcreator.healingmod.init.HealingModModBlocks;
import net.mcreator.healingmod.init.HealingModModEntities;
import net.mcreator.healingmod.init.HealingModModItems;
import net.mcreator.healingmod.init.HealingModModParticleTypes;
import net.mcreator.healingmod.procedures.HealManEntityDiesProcedure;
import net.mcreator.healingmod.procedures.HealManEntityFallsProcedure;
import net.mcreator.healingmod.procedures.HealManEntityIsHurtProcedure;
import net.mcreator.healingmod.procedures.HealManItIsStruckByLightningProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class HealManEntity
extends Animal {
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("healing_mod:healer_biome"));

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        if (SPAWN_BIOMES.contains(event.getName())) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)HealingModModEntities.HEAL_MAN.get(), 25, 4, 4));
        }
    }

    public HealManEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<HealManEntity>)((EntityType)HealingModModEntities.HEAL_MAN.get()), world);
    }

    public HealManEntity(EntityType<HealManEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 150;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, DamageManEntity.class, false, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new RemoveBlockGoal((Block)HealingModModBlocks.HEAL_FLUID.get(), (PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(7, (Goal)new AvoidEntityGoal((PathfinderMob)this, HealManEntity.class, 75.0f, 1.45, 1.3));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49991_.m_5456_()}), true));
        this.f_21345_.m_25352_(9, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50083_.m_5456_()}), true));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50084_.m_5456_()}), true));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_block.hit"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_block.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_cluster.hit"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_cluster.break"));
    }

    public void m_8038_(ServerLevel serverWorld, LightningBolt lightningBolt) {
        super.m_8038_(serverWorld, lightningBolt);
        HealManItIsStruckByLightningProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        HealManEntityFallsProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        return super.m_142535_(l, d, source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        HealManEntityIsHurtProcedure.execute(source.m_7639_());
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source.m_19372_()) {
            return false;
        }
        if (source.m_19385_().equals("trident")) {
            return false;
        }
        if (source == DamageSource.f_19321_) {
            return false;
        }
        if (source == DamageSource.f_19323_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        HealManEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        HealManEntity retval = (HealManEntity)((EntityType)HealingModModEntities.HEAL_MAN.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_142538_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of((Item)HealingModModItems.HEAL_PIECE_FULL.get(), (Item)HealingModModItems.HEAL_FULL.get(), ((Block)HealingModModBlocks.HEAL_FLUID.get()).m_5456_()).contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        HealManEntity entity = this;
        Level world = this.f_19853_;
        for (int l = 0; l < 4; ++l) {
            double x0 = x + (double)this.f_19796_.nextFloat();
            double y0 = y + (double)this.f_19796_.nextFloat();
            double z0 = z + (double)this.f_19796_.nextFloat();
            double dx = ((double)this.f_19796_.nextFloat() - 0.5) * 0.5;
            double dy = ((double)this.f_19796_.nextFloat() - 0.5) * 0.5;
            double dz = ((double)this.f_19796_.nextFloat() - 0.5) * 0.5;
            world.m_7106_((ParticleOptions)((SimpleParticleType)HealingModModParticleTypes.HEAL_PAT.get()), x0, y0, z0, dx, dy, dz);
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)HealingModModEntities.HEAL_MAN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random) && Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        return builder;
    }
}

