/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.healingmod.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.healingmod.world.features.DamageKingFeature;
import net.mcreator.healingmod.world.features.HealLooterFeature;
import net.mcreator.healingmod.world.features.lakes.HealFluidFeature;
import net.mcreator.healingmod.world.features.ores.DamageBlockChargedFeature;
import net.mcreator.healingmod.world.features.ores.DamageBlockEmptyFeature;
import net.mcreator.healingmod.world.features.ores.DamageBlockFullFeature;
import net.mcreator.healingmod.world.features.ores.DamageBlockHalfFeature;
import net.mcreator.healingmod.world.features.ores.HealBlockChargedFeature;
import net.mcreator.healingmod.world.features.ores.HealBlockEmptyFeature;
import net.mcreator.healingmod.world.features.ores.HealBlockFullFeature;
import net.mcreator.healingmod.world.features.ores.HealBlockHalfFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class HealingModModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"healing_mod");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> HEAL_BLOCK_EMPTY = HealingModModFeatures.register("heal_block_empty", HealBlockEmptyFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HealBlockEmptyFeature.GENERATE_BIOMES, HealBlockEmptyFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HEAL_FLUID = HealingModModFeatures.register("heal_fluid", HealFluidFeature::feature, new FeatureRegistration(GenerationStep.Decoration.LAKES, HealFluidFeature.GENERATE_BIOMES, HealFluidFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HEAL_BLOCK_HALF = HealingModModFeatures.register("heal_block_half", HealBlockHalfFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HealBlockHalfFeature.GENERATE_BIOMES, HealBlockHalfFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HEAL_BLOCK_FULL = HealingModModFeatures.register("heal_block_full", HealBlockFullFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HealBlockFullFeature.GENERATE_BIOMES, HealBlockFullFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HEAL_BLOCK_CHARGED = HealingModModFeatures.register("heal_block_charged", HealBlockChargedFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HealBlockChargedFeature.GENERATE_BIOMES, HealBlockChargedFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DAMAGE_BLOCK_EMPTY = HealingModModFeatures.register("damage_block_empty", DamageBlockEmptyFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DamageBlockEmptyFeature.GENERATE_BIOMES, DamageBlockEmptyFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DAMAGE_BLOCK_HALF = HealingModModFeatures.register("damage_block_half", DamageBlockHalfFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DamageBlockHalfFeature.GENERATE_BIOMES, DamageBlockHalfFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DAMAGE_BLOCK_FULL = HealingModModFeatures.register("damage_block_full", DamageBlockFullFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DamageBlockFullFeature.GENERATE_BIOMES, DamageBlockFullFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DAMAGE_BLOCK_CHARGED = HealingModModFeatures.register("damage_block_charged", DamageBlockChargedFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, DamageBlockChargedFeature.GENERATE_BIOMES, DamageBlockChargedFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HEAL_LOOTER = HealingModModFeatures.register("heal_looter", HealLooterFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, HealLooterFeature.GENERATE_BIOMES, HealLooterFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DAMAGE_KING = HealingModModFeatures.register("damage_king", DamageKingFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, DamageKingFeature.GENERATE_BIOMES, DamageKingFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

