/*
 * Decompiled with CFR 0.152.
 */
package net.maketendo.forgedreactor.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.maketendo.forgedreactor.ForgedReactorMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgedReactorModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ForgedReactorMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ForgedReactorMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.JarvisAIName = message.data.JarvisAIName;
                    variables.LinkedTARDISID = message.data.LinkedTARDISID;
                    variables.shootingflames = message.data.shootingflames;
                    variables.Palladium_Poisoning = message.data.Palladium_Poisoning;
                    variables.Arc_Reactor = message.data.Arc_Reactor;
                    variables.Flight = message.data.Flight;
                    variables.BoostParticleDelay = message.data.BoostParticleDelay;
                    variables.Arc_Reactor_Active = message.data.Arc_Reactor_Active;
                    variables.FirstTimeInArmor = message.data.FirstTimeInArmor;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String JarvisAIName = "jarvis";
        public String LinkedTARDISID = "\"\"";
        public boolean shootingflames = false;
        public double Palladium_Poisoning = 0.0;
        public boolean Arc_Reactor = false;
        public boolean Flight = false;
        public boolean BoostParticleDelay = false;
        public boolean Arc_Reactor_Active = false;
        public boolean FirstTimeInArmor = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ForgedReactorMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("JarvisAIName", this.JarvisAIName);
            nbt.m_128359_("LinkedTARDISID", this.LinkedTARDISID);
            nbt.m_128379_("shootingflames", this.shootingflames);
            nbt.m_128347_("Palladium_Poisoning", this.Palladium_Poisoning);
            nbt.m_128379_("Arc_Reactor", this.Arc_Reactor);
            nbt.m_128379_("Flight", this.Flight);
            nbt.m_128379_("BoostParticleDelay", this.BoostParticleDelay);
            nbt.m_128379_("Arc_Reactor_Active", this.Arc_Reactor_Active);
            nbt.m_128379_("FirstTimeInArmor", this.FirstTimeInArmor);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.JarvisAIName = nbt.m_128461_("JarvisAIName");
            this.LinkedTARDISID = nbt.m_128461_("LinkedTARDISID");
            this.shootingflames = nbt.m_128471_("shootingflames");
            this.Palladium_Poisoning = nbt.m_128459_("Palladium_Poisoning");
            this.Arc_Reactor = nbt.m_128471_("Arc_Reactor");
            this.Flight = nbt.m_128471_("Flight");
            this.BoostParticleDelay = nbt.m_128471_("BoostParticleDelay");
            this.Arc_Reactor_Active = nbt.m_128471_("Arc_Reactor_Active");
            this.FirstTimeInArmor = nbt.m_128471_("FirstTimeInArmor");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("forged_reactor", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.JarvisAIName = original.JarvisAIName;
            clone.LinkedTARDISID = original.LinkedTARDISID;
            clone.shootingflames = original.shootingflames;
            clone.Palladium_Poisoning = original.Palladium_Poisoning;
            clone.Arc_Reactor = original.Arc_Reactor;
            clone.Flight = original.Flight;
            clone.BoostParticleDelay = original.BoostParticleDelay;
            clone.Arc_Reactor_Active = original.Arc_Reactor_Active;
            clone.FirstTimeInArmor = original.FirstTimeInArmor;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }
    }
}

