/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.copperntraps.init;

import net.mcreator.copperntraps.potion.BlastedMobEffect;
import net.mcreator.copperntraps.potion.BlurredMobEffect;
import net.mcreator.copperntraps.potion.CureMobEffect;
import net.mcreator.copperntraps.potion.DousedMobEffect;
import net.mcreator.copperntraps.potion.GasolinefireMobEffect;
import net.mcreator.copperntraps.potion.StuckMobEffect;
import net.mcreator.copperntraps.procedures.BlastedEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class CopperntrapsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"copperntraps");
    public static final DeferredHolder<MobEffect, MobEffect> STUCK = REGISTRY.register("stuck", () -> new StuckMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DOUSED = REGISTRY.register("doused", () -> new DousedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GASOLINEFIRE = REGISTRY.register("gasolinefire", () -> new GasolinefireMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLASTED = REGISTRY.register("blasted", () -> new BlastedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BLURRED = REGISTRY.register("blurred", () -> new BlurredMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CURE = REGISTRY.register("cure", () -> new CureMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            CopperntrapsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            CopperntrapsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(BLASTED)) {
            BlastedEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        }
    }
}

