/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ahorrormodtest.network;

import net.mcreator.ahorrormodtest.ThenewherobrinemodMod;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ThenewherobrinemodModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"thenewherobrinemod");

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ThenewherobrinemodMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"thenewherobrinemod", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "thenewherobrinemod_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "thenewherobrinemod_worldvars";
        public double Far_Herobrine_Sword_Type = 1.0;
        public double Herobrine_Spawn_Timer = 0.0;
        public double Herobrine_Spawn_Timer_Time = 0.0;
        public double Herobrine_Spawn_Type = 0.0;
        public double Herobrine_Spawn_Speed = 1.0;
        public double First_Time = 1.0;
        public double Herobrine_Anger = 0.0;
        public double Herobrine_Anger_Action_Type = 0.0;
        public double Herobrine_Not_Spawned_Times = 0.0;
        public double WasJumpscare = 0.0;
        public double CONFIG_JumpscaresEnabled = 1.0;
        public double CONFIG_FarHerobrineEnabled = 1.0;
        public double CONFIG_CrucifixSpawn = 1.0;
        public double CONFIG_HerobrineBehindEnabled = 1.0;
        public Direction HerobrineBehindOrientation = Direction.NORTH;
        public double Events_Not_Spawned_Times = 0.0;
        public double CONFIG_HerobrineAttackEnabled = 1.0;
        public double FarHerobrineNotSpawnedTimes = 0.0;
        public double HerobrineAngerDisplayConfirmed = 0.0;
        public double TEMP_CurrentWorldHourTemp = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.Far_Herobrine_Sword_Type = nbt.getDouble("Far_Herobrine_Sword_Type");
            this.Herobrine_Spawn_Timer = nbt.getDouble("Herobrine_Spawn_Timer");
            this.Herobrine_Spawn_Timer_Time = nbt.getDouble("Herobrine_Spawn_Timer_Time");
            this.Herobrine_Spawn_Type = nbt.getDouble("Herobrine_Spawn_Type");
            this.Herobrine_Spawn_Speed = nbt.getDouble("Herobrine_Spawn_Speed");
            this.First_Time = nbt.getDouble("First_Time");
            this.Herobrine_Anger = nbt.getDouble("Herobrine_Anger");
            this.Herobrine_Anger_Action_Type = nbt.getDouble("Herobrine_Anger_Action_Type");
            this.Herobrine_Not_Spawned_Times = nbt.getDouble("Herobrine_Not_Spawned_Times");
            this.WasJumpscare = nbt.getDouble("WasJumpscare");
            this.CONFIG_JumpscaresEnabled = nbt.getDouble("CONFIG_JumpscaresEnabled");
            this.CONFIG_FarHerobrineEnabled = nbt.getDouble("CONFIG_FarHerobrineEnabled");
            this.CONFIG_CrucifixSpawn = nbt.getDouble("CONFIG_CrucifixSpawn");
            this.CONFIG_HerobrineBehindEnabled = nbt.getDouble("CONFIG_HerobrineBehindEnabled");
            this.HerobrineBehindOrientation = Direction.from3DDataValue((int)nbt.getInt("HerobrineBehindOrientation"));
            this.Events_Not_Spawned_Times = nbt.getDouble("Events_Not_Spawned_Times");
            this.CONFIG_HerobrineAttackEnabled = nbt.getDouble("CONFIG_HerobrineAttackEnabled");
            this.FarHerobrineNotSpawnedTimes = nbt.getDouble("FarHerobrineNotSpawnedTimes");
            this.HerobrineAngerDisplayConfirmed = nbt.getDouble("HerobrineAngerDisplayConfirmed");
            this.TEMP_CurrentWorldHourTemp = nbt.getDouble("TEMP_CurrentWorldHourTemp");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("Far_Herobrine_Sword_Type", this.Far_Herobrine_Sword_Type);
            nbt.putDouble("Herobrine_Spawn_Timer", this.Herobrine_Spawn_Timer);
            nbt.putDouble("Herobrine_Spawn_Timer_Time", this.Herobrine_Spawn_Timer_Time);
            nbt.putDouble("Herobrine_Spawn_Type", this.Herobrine_Spawn_Type);
            nbt.putDouble("Herobrine_Spawn_Speed", this.Herobrine_Spawn_Speed);
            nbt.putDouble("First_Time", this.First_Time);
            nbt.putDouble("Herobrine_Anger", this.Herobrine_Anger);
            nbt.putDouble("Herobrine_Anger_Action_Type", this.Herobrine_Anger_Action_Type);
            nbt.putDouble("Herobrine_Not_Spawned_Times", this.Herobrine_Not_Spawned_Times);
            nbt.putDouble("WasJumpscare", this.WasJumpscare);
            nbt.putDouble("CONFIG_JumpscaresEnabled", this.CONFIG_JumpscaresEnabled);
            nbt.putDouble("CONFIG_FarHerobrineEnabled", this.CONFIG_FarHerobrineEnabled);
            nbt.putDouble("CONFIG_CrucifixSpawn", this.CONFIG_CrucifixSpawn);
            nbt.putDouble("CONFIG_HerobrineBehindEnabled", this.CONFIG_HerobrineBehindEnabled);
            nbt.putInt("HerobrineBehindOrientation", this.HerobrineBehindOrientation.get3DDataValue());
            nbt.putDouble("Events_Not_Spawned_Times", this.Events_Not_Spawned_Times);
            nbt.putDouble("CONFIG_HerobrineAttackEnabled", this.CONFIG_HerobrineAttackEnabled);
            nbt.putDouble("FarHerobrineNotSpawnedTimes", this.FarHerobrineNotSpawnedTimes);
            nbt.putDouble("HerobrineAngerDisplayConfirmed", this.HerobrineAngerDisplayConfirmed);
            nbt.putDouble("TEMP_CurrentWorldHourTemp", this.TEMP_CurrentWorldHourTemp);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

