/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ahorrormodtest.network;

import java.util.function.Supplier;
import net.mcreator.ahorrormodtest.ThenewherobrinemodMod;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThenewherobrinemodModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ThenewherobrinemodMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "thenewherobrinemod_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ThenewherobrinemodMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "thenewherobrinemod_worldvars";
        public double Far_Herobrine_Sword_Type = 1.0;
        public double Herobrine_Spawn_Timer = 0.0;
        public double Herobrine_Spawn_Timer_Time = 0.0;
        public double Herobrine_Spawn_Type = 0.0;
        public double Herobrine_Spawn_Speed = 1.0;
        public double First_Time = 1.0;
        public double Herobrine_Anger = 0.0;
        public double Herobrine_Anger_Action_Type = 0.0;
        public double Herobrine_Not_Spawned_Times = 0.0;
        public double WasJumpscare = 0.0;
        public double CONFIG_JumpscaresEnabled = 1.0;
        public double CONFIG_FarHerobrineEnabled = 1.0;
        public double CONFIG_CrucifixSpawn = 1.0;
        public double CONFIG_HerobrineBehindEnabled = 1.0;
        public Direction HerobrineBehindOrientation = Direction.NORTH;
        public double Events_Not_Spawned_Times = 0.0;
        public double CONFIG_HerobrineAttackEnabled = 1.0;
        public double FarHerobrineNotSpawnedTimes = 0.0;
        public double HerobrineAngerDisplayConfirmed = 0.0;
        public double TEMP_CurrentWorldHourTemp = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.Far_Herobrine_Sword_Type = nbt.m_128459_("Far_Herobrine_Sword_Type");
            this.Herobrine_Spawn_Timer = nbt.m_128459_("Herobrine_Spawn_Timer");
            this.Herobrine_Spawn_Timer_Time = nbt.m_128459_("Herobrine_Spawn_Timer_Time");
            this.Herobrine_Spawn_Type = nbt.m_128459_("Herobrine_Spawn_Type");
            this.Herobrine_Spawn_Speed = nbt.m_128459_("Herobrine_Spawn_Speed");
            this.First_Time = nbt.m_128459_("First_Time");
            this.Herobrine_Anger = nbt.m_128459_("Herobrine_Anger");
            this.Herobrine_Anger_Action_Type = nbt.m_128459_("Herobrine_Anger_Action_Type");
            this.Herobrine_Not_Spawned_Times = nbt.m_128459_("Herobrine_Not_Spawned_Times");
            this.WasJumpscare = nbt.m_128459_("WasJumpscare");
            this.CONFIG_JumpscaresEnabled = nbt.m_128459_("CONFIG_JumpscaresEnabled");
            this.CONFIG_FarHerobrineEnabled = nbt.m_128459_("CONFIG_FarHerobrineEnabled");
            this.CONFIG_CrucifixSpawn = nbt.m_128459_("CONFIG_CrucifixSpawn");
            this.CONFIG_HerobrineBehindEnabled = nbt.m_128459_("CONFIG_HerobrineBehindEnabled");
            this.HerobrineBehindOrientation = Direction.m_122376_((int)nbt.m_128451_("HerobrineBehindOrientation"));
            this.Events_Not_Spawned_Times = nbt.m_128459_("Events_Not_Spawned_Times");
            this.CONFIG_HerobrineAttackEnabled = nbt.m_128459_("CONFIG_HerobrineAttackEnabled");
            this.FarHerobrineNotSpawnedTimes = nbt.m_128459_("FarHerobrineNotSpawnedTimes");
            this.HerobrineAngerDisplayConfirmed = nbt.m_128459_("HerobrineAngerDisplayConfirmed");
            this.TEMP_CurrentWorldHourTemp = nbt.m_128459_("TEMP_CurrentWorldHourTemp");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("Far_Herobrine_Sword_Type", this.Far_Herobrine_Sword_Type);
            nbt.m_128347_("Herobrine_Spawn_Timer", this.Herobrine_Spawn_Timer);
            nbt.m_128347_("Herobrine_Spawn_Timer_Time", this.Herobrine_Spawn_Timer_Time);
            nbt.m_128347_("Herobrine_Spawn_Type", this.Herobrine_Spawn_Type);
            nbt.m_128347_("Herobrine_Spawn_Speed", this.Herobrine_Spawn_Speed);
            nbt.m_128347_("First_Time", this.First_Time);
            nbt.m_128347_("Herobrine_Anger", this.Herobrine_Anger);
            nbt.m_128347_("Herobrine_Anger_Action_Type", this.Herobrine_Anger_Action_Type);
            nbt.m_128347_("Herobrine_Not_Spawned_Times", this.Herobrine_Not_Spawned_Times);
            nbt.m_128347_("WasJumpscare", this.WasJumpscare);
            nbt.m_128347_("CONFIG_JumpscaresEnabled", this.CONFIG_JumpscaresEnabled);
            nbt.m_128347_("CONFIG_FarHerobrineEnabled", this.CONFIG_FarHerobrineEnabled);
            nbt.m_128347_("CONFIG_CrucifixSpawn", this.CONFIG_CrucifixSpawn);
            nbt.m_128347_("CONFIG_HerobrineBehindEnabled", this.CONFIG_HerobrineBehindEnabled);
            nbt.m_128405_("HerobrineBehindOrientation", this.HerobrineBehindOrientation.m_122411_());
            nbt.m_128347_("Events_Not_Spawned_Times", this.Events_Not_Spawned_Times);
            nbt.m_128347_("CONFIG_HerobrineAttackEnabled", this.CONFIG_HerobrineAttackEnabled);
            nbt.m_128347_("FarHerobrineNotSpawnedTimes", this.FarHerobrineNotSpawnedTimes);
            nbt.m_128347_("HerobrineAngerDisplayConfirmed", this.HerobrineAngerDisplayConfirmed);
            nbt.m_128347_("TEMP_CurrentWorldHourTemp", this.TEMP_CurrentWorldHourTemp);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ThenewherobrinemodMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ThenewherobrinemodMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ThenewherobrinemodMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ThenewherobrinemodMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

