/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shinji.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.shinji.block.entity.KozoMatBlockEntity;
import net.mcreator.shinji.client.model.Modelkozo_mat;
import net.mcreator.shinji.init.JourneyToTheWestModBlockEntities;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class KozoMatRenderer
implements BlockEntityRenderer<KozoMatBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    KozoMatRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelkozo_mat.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"journey_to_the_west:textures/block/kozo_mat.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(KozoMatBlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
    }

    public void render(KozoMatBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)JourneyToTheWestModBlockEntities.KOZO_MAT.get(), KozoMatRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelkozo_mat {
        public CustomHierarchicalModel(ModelPart root) {
            super(root);
        }

        public void setupBlockEntityAnim(KozoMatBlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

