/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shinji.entity;

import javax.annotation.Nullable;
import net.mcreator.shinji.procedures.OniEntityIsHurtProcedure;
import net.mcreator.shinji.procedures.OniOnEntityTickUpdateProcedure;
import net.mcreator.shinji.procedures.OniOnInitialEntitySpawnProcedure;
import net.mcreator.shinji.procedures.OniPlaybackConditionProcedure;
import net.mcreator.shinji.procedures.OniPlaybackDeadConditionProcedure;
import net.mcreator.shinji.procedures.OniPlaybackHurtConditionProcedure;
import net.mcreator.shinji.procedures.OniPlaybackIdolConditionProcedure;
import net.mcreator.shinji.procedures.OniPlaybackStanceBrokenConditionProcedure;
import net.mcreator.shinji.procedures.OniPlayerCollidesWithThisEntityProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class OniEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_Attack = SynchedEntityData.defineId(OniEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_Stance = SynchedEntityData.defineId(OniEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_StanceBroken = SynchedEntityData.defineId(OniEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_hurt = SynchedEntityData.defineId(OniEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Dead = SynchedEntityData.defineId(OniEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public OniEntity(EntityType<OniEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Attack, (Object)false);
        builder.define(DATA_Stance, (Object)0);
        builder.define(DATA_StanceBroken, (Object)false);
        builder.define(DATA_hurt, (Object)false);
        builder.define(DATA_Dead, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.iron_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.iron_golem.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.iron_golem.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        OniEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        OniEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity);
        return super.hurtServer(level, damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        OniOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataAttack", ((Boolean)this.entityData.get(DATA_Attack)).booleanValue());
        compound.putInt("DataStance", ((Integer)this.entityData.get(DATA_Stance)).intValue());
        compound.putBoolean("DataStanceBroken", ((Boolean)this.entityData.get(DATA_StanceBroken)).booleanValue());
        compound.putBoolean("Datahurt", ((Boolean)this.entityData.get(DATA_hurt)).booleanValue());
        compound.putBoolean("DataDead", ((Boolean)this.entityData.get(DATA_Dead)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataAttack")) {
            this.entityData.set(DATA_Attack, (Object)compound.getBoolean("DataAttack"));
        }
        if (compound.contains("DataStance")) {
            this.entityData.set(DATA_Stance, (Object)compound.getInt("DataStance"));
        }
        if (compound.contains("DataStanceBroken")) {
            this.entityData.set(DATA_StanceBroken, (Object)compound.getBoolean("DataStanceBroken"));
        }
        if (compound.contains("Datahurt")) {
            this.entityData.set(DATA_hurt, (Object)compound.getBoolean("Datahurt"));
        }
        if (compound.contains("DataDead")) {
            this.entityData.set(DATA_Dead, (Object)compound.getBoolean("DataDead"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(OniPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(OniPlaybackStanceBrokenConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(OniPlaybackHurtConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(OniPlaybackIdolConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(OniPlaybackDeadConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        OniOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public void playerTouch(Player sourceentity) {
        super.playerTouch(sourceentity);
        OniPlayerCollidesWithThisEntityProcedure.execute((Entity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.1f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 120.0);
        builder = builder.add(Attributes.ARMOR, 4.5);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 8.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.1);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.8);
        return builder;
    }
}

