/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.amethystrevamped.client.renderer;

import net.mcreator.amethystrevamped.client.model.Modelbraze;
import net.mcreator.amethystrevamped.client.model.animations.brazeAnimation;
import net.mcreator.amethystrevamped.entity.BrazeEntity;
import net.mcreator.amethystrevamped.procedures.BrazeIsEntityModelShakingProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BrazeRenderer
extends MobRenderer<BrazeEntity, LivingEntityRenderState, Modelbraze> {
    private BrazeEntity entity = null;

    public BrazeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelbraze.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(BrazeEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"amethyst_revamped:textures/entities/braze_v1.png");
    }

    protected boolean isShaking(LivingEntityRenderState state) {
        Level world = this.entity.level();
        double x = this.entity.getX();
        double y = this.entity.getY();
        double z = this.entity.getZ();
        return BrazeIsEntityModelShakingProcedure.execute((LevelAccessor)world, x, y, z);
    }

    private static final class AnimatedModel
    extends Modelbraze {
        private BrazeEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(BrazeEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, brazeAnimation.FLY, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

