/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.amethystrevamped.entity;

import net.mcreator.amethystrevamped.procedures.ConditionProcedure;
import net.mcreator.amethystrevamped.procedures.CrystaologerEntityIsHurtProcedure;
import net.mcreator.amethystrevamped.procedures.CrystaologerOnEntityTickUpdateProcedure;
import net.mcreator.amethystrevamped.procedures.CrystaologerPlaybackCondition0Procedure;
import net.mcreator.amethystrevamped.procedures.CrystaologerPlaybackCondition1Procedure;
import net.mcreator.amethystrevamped.procedures.CrystaologerPlaybackCondition3Procedure;
import net.mcreator.amethystrevamped.procedures.CrystaologerPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class CrystaologerEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_attacking = SynchedEntityData.defineId(CrystaologerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_evoking = SynchedEntityData.defineId(CrystaologerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_being_hurt = SynchedEntityData.defineId(CrystaologerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public CrystaologerEntity(EntityType<CrystaologerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attacking, (Object)false);
        builder.define(DATA_evoking, (Object)false);
        builder.define(DATA_being_hurt, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false){

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f){

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canUse() && ConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrystaologerEntity.this.getX();
                double y = CrystaologerEntity.this.getY();
                double z = CrystaologerEntity.this.getZ();
                CrystaologerEntity entity = CrystaologerEntity.this;
                Level world = CrystaologerEntity.this.level();
                return super.canContinueToUse() && ConditionProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.skeleton.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        CrystaologerEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        CrystaologerEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity);
        return super.hurtServer(level, damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Dataattacking", ((Boolean)this.entityData.get(DATA_attacking)).booleanValue());
        compound.putBoolean("Dataevoking", ((Boolean)this.entityData.get(DATA_evoking)).booleanValue());
        compound.putBoolean("Databeing_hurt", ((Boolean)this.entityData.get(DATA_being_hurt)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattacking")) {
            this.entityData.set(DATA_attacking, (Object)compound.getBoolean("Dataattacking"));
        }
        if (compound.contains("Dataevoking")) {
            this.entityData.set(DATA_evoking, (Object)compound.getBoolean("Dataevoking"));
        }
        if (compound.contains("Databeing_hurt")) {
            this.entityData.set(DATA_being_hurt, (Object)compound.getBoolean("Databeing_hurt"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(CrystaologerPlaybackCondition3Procedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(CrystaologerPlaybackCondition0Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(CrystaologerPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(CrystaologerPlaybackCondition1Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CrystaologerOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 70.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.2);
        return builder;
    }
}

