/*
 * Decompiled with CFR 0.152.
 */
package omegarecon.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import omegarecon.OmegareconMod;
import omegarecon.procedures.ArmoryItemAirforceBootsProcedure;
import omegarecon.procedures.ArmoryItemAirforceHelmetProcedure;
import omegarecon.procedures.ArmoryItemAirforcePantsProcedure;
import omegarecon.procedures.ArmoryItemAirforceVestProcedure;
import omegarecon.procedures.ArmoryItemBlackoutBootsProcedure;
import omegarecon.procedures.ArmoryItemBlackoutHelmetProcedure;
import omegarecon.procedures.ArmoryItemBlackoutPantsProcedure;
import omegarecon.procedures.ArmoryItemBlackoutVestProcedure;
import omegarecon.procedures.ArmoryItemCombatBootsProcedure;
import omegarecon.procedures.ArmoryItemCrimChinguardProcedure;
import omegarecon.procedures.ArmoryItemCrimHelmetProcedure;
import omegarecon.procedures.ArmoryItemCrimVestProcedure;
import omegarecon.procedures.ArmoryItemCrimsonBootsProcedure;
import omegarecon.procedures.ArmoryItemDyneemaHelmetProcedure;
import omegarecon.procedures.ArmoryItemEnforcerHelmetProcedure;
import omegarecon.procedures.ArmoryItemGunnerVestProcedure;
import omegarecon.procedures.ArmoryItemKevlarChinguardProcedure;
import omegarecon.procedures.ArmoryItemKevlarHelmetProcedure;
import omegarecon.procedures.ArmoryItemKevlarVestProcedure;
import omegarecon.procedures.ArmoryPurchaseItemsProcedure;
import omegarecon.procedures.ExitGuiRightclickedProcedure;
import omegarecon.procedures.MirrorPreviewModelProcedure;
import omegarecon.procedures.TestGuiClearSlotsProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TestGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TestGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TestGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TestGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TestGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TestGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ArmoryPurchaseItemsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ArmoryItemKevlarHelmetProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            ArmoryItemDyneemaHelmetProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ArmoryItemKevlarVestProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ExitGuiRightclickedProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            TestGuiClearSlotsProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            ArmoryItemGunnerVestProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            MirrorPreviewModelProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            ArmoryItemCrimHelmetProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            ArmoryItemCrimVestProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            ArmoryItemKevlarChinguardProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            ArmoryItemCrimChinguardProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            ArmoryItemCombatBootsProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            ArmoryItemEnforcerHelmetProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            ArmoryItemAirforceVestProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            ArmoryItemAirforcePantsProcedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            ArmoryItemAirforceHelmetProcedure.execute((Entity)entity);
        }
        if (buttonID == 17) {
            ArmoryItemAirforceBootsProcedure.execute((Entity)entity);
        }
        if (buttonID == 18) {
            ArmoryItemCrimsonBootsProcedure.execute((Entity)entity);
        }
        if (buttonID == 19) {
            ArmoryItemBlackoutHelmetProcedure.execute((Entity)entity);
        }
        if (buttonID == 20) {
            ArmoryItemBlackoutVestProcedure.execute((Entity)entity);
        }
        if (buttonID == 21) {
            ArmoryItemBlackoutPantsProcedure.execute((Entity)entity);
        }
        if (buttonID == 22) {
            ArmoryItemBlackoutBootsProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        OmegareconMod.addNetworkMessage(TestGuiButtonMessage.class, TestGuiButtonMessage::buffer, TestGuiButtonMessage::new, TestGuiButtonMessage::handler);
    }
}

