/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.genz.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.genz.block.Z1Block;
import net.mcreator.genz.block.entity.Z1BlockEntity;
import net.mcreator.genz.client.model.Modelchicken_zombie1;
import net.mcreator.genz.init.GenzModBlockEntities;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class Z1Renderer
implements BlockEntityRenderer<Z1BlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    Z1Renderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelchicken_zombie1.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"genz:textures/block/chicken_zombie1.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(Z1BlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
    }

    public void render(Z1BlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(Z1Block.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)GenzModBlockEntities.Z_1.get(), Z1Renderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelchicken_zombie1 {
        public CustomHierarchicalModel(ModelPart root) {
            super(root);
        }

        public void setupBlockEntityAnim(Z1BlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

