/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lightsofdusk.init;

import net.mcreator.lightsofdusk.potion.InsanityMobEffect;
import net.mcreator.lightsofdusk.potion.IntoxicationMobEffect;
import net.mcreator.lightsofdusk.procedures.InsanityEffectExpires2Procedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class LightsOfDuskModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"lights_of_dusk");
    public static final DeferredHolder<MobEffect, MobEffect> INTOXICATION = REGISTRY.register("intoxication", () -> new IntoxicationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INSANITY = REGISTRY.register("insanity", () -> new InsanityMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            LightsOfDuskModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            LightsOfDuskModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(INSANITY)) {
            InsanityEffectExpires2Procedure.execute((LevelAccessor)entity.level(), entity);
        }
    }
}

