/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theanythingmod.entity;

import java.util.function.Predicate;
import net.mcreator.theanythingmod.init.TheAnythingModModEntities;
import net.mcreator.theanythingmod.init.TheAnythingModModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class NautilusEntity
extends Animal {
    public NautilusEntity(EntityType<NautilusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (NautilusEntity.this.isInWater()) {
                    NautilusEntity.this.setDeltaMovement(NautilusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !NautilusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - NautilusEntity.this.getX();
                    double dy = this.wantedY - NautilusEntity.this.getY();
                    double dz = this.wantedZ - NautilusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * NautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    NautilusEntity.this.setYRot(this.rotlerp(NautilusEntity.this.getYRot(), f, 10.0f));
                    NautilusEntity.this.yBodyRot = NautilusEntity.this.getYRot();
                    NautilusEntity.this.yHeadRot = NautilusEntity.this.getYRot();
                    if (NautilusEntity.this.isInWater()) {
                        NautilusEntity.this.setSpeed((float)NautilusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        NautilusEntity.this.setXRot(this.rotlerp(NautilusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(NautilusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        NautilusEntity.this.setZza(f3 * f1);
                        NautilusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        NautilusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    NautilusEntity.this.setSpeed(0.0f);
                    NautilusEntity.this.setYya(0.0f);
                    NautilusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.COD), false));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.SALMON), false));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.TROPICAL_FISH), false));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.PUFFERFISH), false));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)((ItemLike)TheAnythingModModItems.RAW_FISH.get())), false));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.COD_BUCKET), false));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.SALMON_BUCKET), false));
        this.goalSelector.addGoal(8, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.TROPICAL_FISH_BUCKET), false));
        this.goalSelector.addGoal(9, (Goal)new TemptGoal((PathfinderMob)this, 10.0, (Predicate)Ingredient.of((ItemLike)Items.PUFFERFISH_BUCKET), false));
        this.goalSelector.addGoal(10, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 10.0, 40));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(12, (Goal)new AvoidEntityGoal((PathfinderMob)this, Drowned.class, 20.0f, 15.0, 12.0));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)Items.NAUTILUS_SHELL));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"ui.hud.bubble_pop"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.shulker.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.shulker.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        NautilusEntity retval = (NautilusEntity)((EntityType)TheAnythingModModEntities.NAUTILUS.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TheAnythingModModItems.RAW_FISH.get(), Items.COD, Items.SALMON, Items.PUFFERFISH, Items.TROPICAL_FISH}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        NautilusEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        NautilusEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)TheAnythingModModEntities.NAUTILUS.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos).is(Blocks.WATER) && world.getBlockState(pos.above()).is(Blocks.WATER), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

