/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.thinproducts.init;

import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredHolder;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.BlockItem;

import net.mcreator.thinproducts.item.RawFabricItem;
import net.mcreator.thinproducts.item.PolyethelyneItem;
import net.mcreator.thinproducts.item.MillItem;
import net.mcreator.thinproducts.item.FabricClothingItem;
import net.mcreator.thinproducts.item.AntidoteItem;
import net.mcreator.thinproducts.ThinProductsMod;

import java.util.function.Function;

public class ThinProductsModItems {
	public static final DeferredRegister.Items REGISTRY = DeferredRegister.createItems(ThinProductsMod.MODID);
	public static final DeferredItem<Item> FABRIC_CLOTHING_HELMET = register("fabric_clothing_helmet", FabricClothingItem.Helmet::new);
	public static final DeferredItem<Item> FABRIC_CLOTHING_CHESTPLATE = register("fabric_clothing_chestplate", FabricClothingItem.Chestplate::new);
	public static final DeferredItem<Item> FABRIC_CLOTHING_LEGGINGS = register("fabric_clothing_leggings", FabricClothingItem.Leggings::new);
	public static final DeferredItem<Item> FABRIC_CLOTHING_BOOTS = register("fabric_clothing_boots", FabricClothingItem.Boots::new);
	public static final DeferredItem<Item> RAW_FABRIC = register("raw_fabric", RawFabricItem::new);
	public static final DeferredItem<Item> HEMP = block(ThinProductsModBlocks.HEMP);
	public static final DeferredItem<Item> MILL = register("mill", MillItem::new);
	public static final DeferredItem<Item> POLYETHELYNE = register("polyethelyne", PolyethelyneItem::new);
	public static final DeferredItem<Item> ANTIDOTE = register("antidote", AntidoteItem::new);
	public static final DeferredItem<Item> PROCESSER = block(ThinProductsModBlocks.PROCESSER);

	// Start of user code block custom items
	// End of user code block custom items
	private static <I extends Item> DeferredItem<I> register(String name, Function<Item.Properties, ? extends I> supplier) {
		return REGISTRY.registerItem(name, supplier, new Item.Properties());
	}

	private static DeferredItem<Item> block(DeferredHolder<Block, Block> block) {
		return block(block, new Item.Properties());
	}

	private static DeferredItem<Item> block(DeferredHolder<Block, Block> block, Item.Properties properties) {
		return REGISTRY.registerItem(block.getId().getPath(), prop -> new BlockItem(block.get(), prop), properties);
	}
}