/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.creeperhell;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.creeperhell.init.CreeperhellModAttributes;
import net.mcreator.creeperhell.init.CreeperhellModBlockEntities;
import net.mcreator.creeperhell.init.CreeperhellModBlocks;
import net.mcreator.creeperhell.init.CreeperhellModEnchantments;
import net.mcreator.creeperhell.init.CreeperhellModEntities;
import net.mcreator.creeperhell.init.CreeperhellModItems;
import net.mcreator.creeperhell.init.CreeperhellModMenus;
import net.mcreator.creeperhell.init.CreeperhellModMobEffects;
import net.mcreator.creeperhell.init.CreeperhellModPaintings;
import net.mcreator.creeperhell.init.CreeperhellModParticleTypes;
import net.mcreator.creeperhell.init.CreeperhellModPotions;
import net.mcreator.creeperhell.init.CreeperhellModSounds;
import net.mcreator.creeperhell.init.CreeperhellModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="creeperhell")
public class CreeperhellMod {
    public static final Logger LOGGER = LogManager.getLogger(CreeperhellMod.class);
    public static final String MODID = "creeperhell";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("creeperhell", "creeperhell"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CreeperhellMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CreeperhellModSounds.REGISTRY.register(bus);
        CreeperhellModBlocks.REGISTRY.register(bus);
        CreeperhellModBlockEntities.REGISTRY.register(bus);
        CreeperhellModItems.REGISTRY.register(bus);
        CreeperhellModEntities.REGISTRY.register(bus);
        CreeperhellModEnchantments.REGISTRY.register(bus);
        CreeperhellModTabs.REGISTRY.register(bus);
        CreeperhellModMobEffects.REGISTRY.register(bus);
        CreeperhellModPotions.REGISTRY.register(bus);
        CreeperhellModPaintings.REGISTRY.register(bus);
        CreeperhellModParticleTypes.REGISTRY.register(bus);
        CreeperhellModMenus.REGISTRY.register(bus);
        CreeperhellModAttributes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

