/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.fluid;

import net.mcreator.curb.init.CurbModBlocks;
import net.mcreator.curb.init.CurbModFluidTypes;
import net.mcreator.curb.init.CurbModFluids;
import net.mcreator.curb.init.CurbModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class CorrosiveAcidFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)CurbModFluidTypes.CORROSIVE_ACID_TYPE.get(), () -> (Fluid)CurbModFluids.CORROSIVE_ACID.get(), () -> (Fluid)CurbModFluids.FLOWING_CORROSIVE_ACID.get()).explosionResistance(100.0f).bucket(() -> (Item)CurbModItems.CORROSIVE_ACID_BUCKET.get()).block(() -> (LiquidBlock)CurbModBlocks.CORROSIVE_ACID.get());

    private CorrosiveAcidFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.BUBBLE_POP;
    }

    public static class Flowing
    extends CorrosiveAcidFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends CorrosiveAcidFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

