/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.procedures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class DrillOnTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        double targetblockX = 0.0;
        double targetblockZ = 0.0;
        if (DrillOnTickUpdateProcedure.getEnergyStored(world, BlockPos.containing((double)x, (double)y, (double)z), null) >= 100) {
            if (DrillOnTickUpdateProcedure.getDirectionFromBlockState(world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z))) == Direction.NORTH) {
                targetblockX = x;
                targetblockZ = z - 1.0;
            }
            if (DrillOnTickUpdateProcedure.getDirectionFromBlockState(world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z))) == Direction.SOUTH) {
                targetblockX = x;
                targetblockZ = z + 1.0;
            }
            if (DrillOnTickUpdateProcedure.getDirectionFromBlockState(world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z))) == Direction.EAST) {
                targetblockX = x + 1.0;
                targetblockZ = z;
            }
            if (DrillOnTickUpdateProcedure.getDirectionFromBlockState(world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z))) == Direction.WEST) {
                targetblockX = x - 1.0;
                targetblockZ = z;
            }
            if (!world.getBlockState(BlockPos.containing((double)targetblockX, (double)y, (double)targetblockZ)).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:needs_diamond_tool"))) && world.getBlockState(BlockPos.containing((double)targetblockX, (double)y, (double)targetblockZ)).getBlock() != Blocks.BEDROCK) {
                ILevelExtension _ext;
                IEnergyStorage _entityStorage;
                if (world instanceof ILevelExtension && (_entityStorage = (IEnergyStorage)(_ext = (ILevelExtension)world).getCapability(Capabilities.EnergyStorage.BLOCK, BlockPos.containing((double)x, (double)y, (double)z), null)) != null) {
                    _entityStorage.extractEnergy(100, false);
                }
                BlockPos _pos = BlockPos.containing((double)targetblockX, (double)y, (double)targetblockZ);
                Block.dropResources((BlockState)world.getBlockState(_pos), (LevelAccessor)world, (BlockPos)BlockPos.containing((double)(targetblockX + 0.5), (double)y, (double)(targetblockZ + 0.5)), null);
                world.destroyBlock(_pos, false);
            }
        }
    }

    public static int getEnergyStored(LevelAccessor level, BlockPos pos, Direction direction) {
        ILevelExtension levelExtension;
        IEnergyStorage energyStorage;
        if (level instanceof ILevelExtension && (energyStorage = (IEnergyStorage)(levelExtension = (ILevelExtension)level).getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)direction)) != null) {
            return energyStorage.getEnergyStored();
        }
        return 0;
    }

    private static Direction getDirectionFromBlockState(BlockState blockState) {
        EnumProperty ep;
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property instanceof EnumProperty && (ep = (EnumProperty)property).getValueClass() == Direction.class) {
            return (Direction)blockState.getValue((Property)ep);
        }
        property = blockState.getBlock().getStateDefinition().getProperty("axis");
        if (property instanceof EnumProperty && (ep = (EnumProperty)property).getValueClass() == Direction.Axis.class) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

