/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.curb.procedures.ExplodeblockProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExplosiveGelatinBlockBlock
extends FallingBlock {
    public static final MapCodec<ExplosiveGelatinBlockBlock> CODEC = ExplosiveGelatinBlockBlock.simpleCodec(ExplosiveGelatinBlockBlock::new);

    public MapCodec<ExplosiveGelatinBlockBlock> codec() {
        return CODEC;
    }

    public ExplosiveGelatinBlockBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SLIME_BLOCK).instabreak().noCollission().friction(0.7f).speedFactor(0.5f).jumpFactor(0.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
    }

    public int getLightBlock(BlockState state) {
        return 3;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.WALKABLE;
    }

    public void wasExploded(ServerLevel world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        ExplodeblockProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        ExplodeblockProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

