/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.fluid.types;

import com.mojang.blaze3d.shaders.FogShape;
import net.mcreator.curb.init.CurbModFluidTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector4f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CorrosiveAcidFluidType
extends FluidType {
    public CorrosiveAcidFluidType() {
        super(FluidType.Properties.create().canSwim(false).canDrown(false).pathType(PathType.LAVA).adjacentPathType(null).motionScale(0.007).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"item.bucket.empty"))).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
    }

    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"curb:block/corrosive_acid");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"curb:block/corrosive_acid_flowing");
            private static final ResourceLocation RENDER_OVERLAY_TEXTURE = ResourceLocation.parse((String)"curb:textures/corrosive_acid_overlay.png");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return RENDER_OVERLAY_TEXTURE;
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                return new Vector4f(0.0f, 0.8f, 0.8f, fluidFogColor.w);
            }

            public FogParameters modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, FogParameters fogParameters) {
                float nearDistance = fogParameters.start();
                float farDistance = fogParameters.end();
                Entity entity = camera.getEntity();
                Level world = entity.level();
                return new FogParameters(0.0f, 5.0f, FogShape.SPHERE, fogParameters.red(), fogParameters.green(), fogParameters.blue(), fogParameters.alpha());
            }
        }, new FluidType[]{(FluidType)CurbModFluidTypes.CORROSIVE_ACID_TYPE.get()});
    }
}

