/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.curb.init.CurbModBlockEntities;
import net.mcreator.curb.world.inventory.ThoriumReactorGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ThoriumReactorBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private final EnergyStorage energyStorage = new EnergyStorage(100000, 5000, 5000, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                ThoriumReactorBlockEntity.this.setChanged();
                ThoriumReactorBlockEntity.this.level.sendBlockUpdated(ThoriumReactorBlockEntity.this.worldPosition, ThoriumReactorBlockEntity.this.level.getBlockState(ThoriumReactorBlockEntity.this.worldPosition), ThoriumReactorBlockEntity.this.level.getBlockState(ThoriumReactorBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                ThoriumReactorBlockEntity.this.setChanged();
                ThoriumReactorBlockEntity.this.level.sendBlockUpdated(ThoriumReactorBlockEntity.this.worldPosition, ThoriumReactorBlockEntity.this.level.getBlockState(ThoriumReactorBlockEntity.this.worldPosition), ThoriumReactorBlockEntity.this.level.getBlockState(ThoriumReactorBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };
    private final FluidTank fluidTank = new FluidTank(1000, fs -> fs.getFluid() == Fluids.WATER){

        protected void onContentsChanged() {
            super.onContentsChanged();
            ThoriumReactorBlockEntity.this.setChanged();
            ThoriumReactorBlockEntity.this.level.sendBlockUpdated(ThoriumReactorBlockEntity.this.worldPosition, ThoriumReactorBlockEntity.this.level.getBlockState(ThoriumReactorBlockEntity.this.worldPosition), ThoriumReactorBlockEntity.this.level.getBlockState(ThoriumReactorBlockEntity.this.worldPosition), 2);
        }
    };

    public ThoriumReactorBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)CurbModBlockEntities.THORIUM_REACTOR.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        Tag tag = compound.get("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
        if ((tag = compound.get("fluidTank")) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.fluidTank.readFromNBT(lookupProvider, compoundTag);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
        compound.put("fluidTank", (Tag)this.fluidTank.writeToNBT(lookupProvider, new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"thorium_reactor");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new ThoriumReactorGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Thorium Reactor");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 2;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemstack, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemstack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack itemstack, Direction direction) {
        return true;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

