/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.init;

import net.mcreator.curb.entity.DistortedButterflyEntity;
import net.mcreator.curb.entity.PeaprojectileEntity;
import net.mcreator.curb.entity.RedstoneGolemEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CurbModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"curb");
    public static final DeferredHolder<EntityType<?>, EntityType<PeaprojectileEntity>> PEAPROJECTILE = CurbModEntities.register("peaprojectile", EntityType.Builder.of(PeaprojectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<DistortedButterflyEntity>> DISTORTED_BUTTERFLY = CurbModEntities.register("distorted_butterfly", EntityType.Builder.of(DistortedButterflyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setUpdateInterval(3).fireImmune().sized(0.25f, 0.25f));
    public static final DeferredHolder<EntityType<?>, EntityType<RedstoneGolemEntity>> REDSTONE_GOLEM = CurbModEntities.register("redstone_golem", EntityType.Builder.of(RedstoneGolemEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.75f, 1.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curb", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DistortedButterflyEntity.init(event);
        RedstoneGolemEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DISTORTED_BUTTERFLY.get(), DistortedButterflyEntity.createAttributes().build());
        event.put((EntityType)REDSTONE_GOLEM.get(), RedstoneGolemEntity.createAttributes().build());
    }
}

