/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.curb.init;

import net.mcreator.curb.potion.CorrosionResistanceMobEffect;
import net.mcreator.curb.potion.HallucinationsMobEffect;
import net.mcreator.curb.procedures.ReturnToOverworlProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class CurbModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"curb");
    public static final DeferredHolder<MobEffect, MobEffect> HALLUCINATIONS = REGISTRY.register("hallucinations", () -> new HallucinationsMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CORROSION_RESISTANCE = REGISTRY.register("corrosion_resistance", () -> new CorrosionResistanceMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            CurbModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            CurbModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(HALLUCINATIONS)) {
            ReturnToOverworlProcedure.execute((LevelAccessor)entity.level(), entity);
        }
    }
}

