/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.updatemize_o5.network;

import net.mcreator.updatemize_o5.UpdatemizeO5Mod;
import net.mcreator.updatemize_o5.procedures.NautilusFlyUpOnKeyPressedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record NautilusFlyUpMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NautilusFlyUpMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"updatemize_o5", (String)"key_nautilus_fly_up"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NautilusFlyUpMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new NautilusFlyUpMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<NautilusFlyUpMessage> type() {
        return TYPE;
    }

    public static void handleData(NautilusFlyUpMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> NautilusFlyUpMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            NautilusFlyUpOnKeyPressedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        UpdatemizeO5Mod.addNetworkMessage(TYPE, STREAM_CODEC, NautilusFlyUpMessage::handleData);
    }
}

