/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.k_balance.block;

import java.util.List;
import net.mcreator.k_balance.procedures.PhantomMembraneBlockEntityCollidesInTheBlockProcedure;
import net.mcreator.k_balance.procedures.PhantomMembraneBlockSpecialInformationProcedure;
import net.mcreator.k_balance.procedures.PhantomMembraneRedstoneOnProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PhantomMembraneBlockBlock
extends Block {
    public PhantomMembraneBlockBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.SLIME_BLOCK).strength(1.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        Entity entity = itemstack.getEntityRepresentation() != null ? itemstack.getEntityRepresentation() : Minecraft.getInstance().player;
        String hoverText = PhantomMembraneBlockSpecialInformationProcedure.execute();
        if (hoverText != null) {
            for (String line : hoverText.split("\n")) {
                list.add((Component)Component.literal((String)line));
            }
        }
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        if (world.getBestNeighborSignal(pos) > 0) {
            PhantomMembraneRedstoneOnProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        PhantomMembraneBlockEntityCollidesInTheBlockProcedure.execute(entity);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        PhantomMembraneBlockEntityCollidesInTheBlockProcedure.execute(entity);
    }
}

