/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.k_balance.client.renderer;

import net.mcreator.k_balance.client.model.Modelburied;
import net.mcreator.k_balance.client.model.animations.buriedAnimation;
import net.mcreator.k_balance.entity.BuriedEntity;
import net.mcreator.k_balance.procedures.BuriedIsEntityModelShakingProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class BuriedRenderer
extends MobRenderer<BuriedEntity, Modelburied<BuriedEntity>> {
    public BuriedRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelburied.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(BuriedEntity entity) {
        return ResourceLocation.parse((String)"k_balance:textures/entities/buried.png");
    }

    protected boolean isShaking(BuriedEntity entity) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return BuriedIsEntityModelShakingProcedure.execute((Entity)entity);
    }

    private static final class AnimatedModel
    extends Modelburied<BuriedEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<BuriedEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(BuriedEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, buriedAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(buriedAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, buriedAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(BuriedEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

