/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.k_balance.network;

import java.util.HashMap;
import net.mcreator.k_balance.KBalanceMod;
import net.mcreator.k_balance.procedures.CrusherDecreaseMultipleProcedure;
import net.mcreator.k_balance.procedures.CrusherGUIItemCheckDecreaseProcedure;
import net.mcreator.k_balance.procedures.CrusherGUIItemDecreaseProcedure;
import net.mcreator.k_balance.procedures.CrusherGUISlot0AvoidCheatProcedure;
import net.mcreator.k_balance.world.inventory.CrusherGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrusherGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrusherGUISlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"k_balance", (String)"crusher_gui_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrusherGUISlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new CrusherGUISlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CrusherGUISlotMessage> type() {
        return TYPE;
    }

    public static void handleData(CrusherGUISlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                CrusherGUISlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = CrusherGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            CrusherGUISlot0AvoidCheatProcedure.execute((Entity)entity);
        }
        if (slot == 0 && changeType == 1) {
            CrusherGUIItemCheckDecreaseProcedure.execute((Entity)entity);
        }
        if (slot == 1 && changeType == 1) {
            CrusherGUIItemDecreaseProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 1 && changeType == 2) {
            int amount = meta;
            CrusherDecreaseMultipleProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        KBalanceMod.addNetworkMessage(TYPE, STREAM_CODEC, CrusherGUISlotMessage::handleData);
    }
}

