/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.prehistoricchange.entity;

import javax.annotation.Nullable;
import net.mcreator.prehistoricchange.init.PrehistoricChangeModEntities;
import net.mcreator.prehistoricchange.init.PrehistoricChangeModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BlastAttackEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)PrehistoricChangeModItems.BLASTERATTACK.get());
    private int knockback = 0;

    public BlastAttackEntity(EntityType<? extends BlastAttackEntity> type, Level world) {
        super(type, world);
        this.setNoGravity(true);
    }

    public BlastAttackEntity(EntityType<? extends BlastAttackEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
        this.setNoGravity(true);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    public BlastAttackEntity(EntityType<? extends BlastAttackEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
        this.setNoGravity(true);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)PrehistoricChangeModItems.BLASTERATTACK.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        } else {
            super.doKnockback(livingEntity, damageSource);
        }
    }

    public void tick() {
        super.tick();
        if (this.isInGround()) {
            this.discard();
        }
    }

    public static BlastAttackEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return BlastAttackEntity.shoot(world, entity, source, 2.0f, 13.0, 1);
    }

    public static BlastAttackEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return BlastAttackEntity.shoot(world, entity, source, pullingPower * 2.0f, 13.0, 1);
    }

    public static BlastAttackEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BlastAttackEntity entityarrow = new BlastAttackEntity((EntityType<? extends BlastAttackEntity>)((EntityType)PrehistoricChangeModEntities.BLAST_ATTACK.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static BlastAttackEntity shoot(LivingEntity entity, LivingEntity target) {
        BlastAttackEntity entityarrow = new BlastAttackEntity((EntityType<? extends BlastAttackEntity>)((EntityType)PrehistoricChangeModEntities.BLAST_ATTACK.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 4.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(13.0);
        entityarrow.setKnockback(1);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

