/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.prehistoricchange.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.prehistoricchange.init.PrehistoricChangeModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class PrehistoricChangeModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry levelStemTypeRegistry = server.registryAccess().lookupOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().lookupOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            Holder dimensionType = levelStem.type();
            if (!dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) continue;
            ChunkGenerator chunkGenerator = levelStem.generator();
            BiomeSource biomeSource = chunkGenerator.getBiomeSource();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
                PrehistoricChangeModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.3f, (float)0.6f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.12f, (float)0.3f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)0.0f, (float)2.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prehistoric_change", (String)"karbon_forest")))));
                PrehistoricChangeModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.3f, (float)0.6f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.12f, (float)0.3f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)0.0f, (float)2.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prehistoric_change", (String)"karbon_forest")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            ((PrehistoricChangeModNoiseGeneratorSettings)noiseGenerator.settings.value()).setprehistoric_changeDimensionTypeReference((Holder<DimensionType>)dimensionType);
        }
    }

    public static SurfaceRules.RuleSource adaptSurfaceRule(SurfaceRules.RuleSource currentRuleSource, Holder<DimensionType> dimensionType) {
        if (dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) {
            return PrehistoricChangeModBiomes.injectOverworldSurfaceRules(currentRuleSource);
        }
        return currentRuleSource;
    }

    private static SurfaceRules.RuleSource injectOverworldSurfaceRules(SurfaceRules.RuleSource currentRuleSource) {
        ArrayList<SurfaceRules.RuleSource> customSurfaceRules = new ArrayList<SurfaceRules.RuleSource>();
        customSurfaceRules.add(PrehistoricChangeModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prehistoric_change", (String)"karbon_forest")), Blocks.GRASS_BLOCK.defaultBlockState(), ((Block)PrehistoricChangeModBlocks.TORF.get()).defaultBlockState(), ((Block)PrehistoricChangeModBlocks.TORF.get()).defaultBlockState()));
        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            customSurfaceRules.addAll(sequenceRuleSource.sequence());
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
        }
        customSurfaceRules.add(currentRuleSource);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    public static interface PrehistoricChangeModNoiseGeneratorSettings {
        public void setprehistoric_changeDimensionTypeReference(Holder<DimensionType> var1);
    }
}

