/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.savannaup.recipe.brewing;

import net.mcreator.savannaup.init.SavannaupModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

@EventBusSubscriber
public class CraftFireResistBrewingRecipe
implements IBrewingRecipe {
    @SubscribeEvent
    public static void init(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addRecipe((IBrewingRecipe)new CraftFireResistBrewingRecipe());
    }

    public boolean isInput(ItemStack input) {
        Item inputItem = input.getItem();
        return (inputItem == Items.POTION || inputItem == Items.SPLASH_POTION || inputItem == Items.LINGERING_POTION) && ((PotionContents)input.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.FIRE_RESISTANCE);
    }

    public boolean isIngredient(ItemStack ingredient) {
        return Ingredient.of((ItemLike)((ItemLike)SavannaupModItems.BAOBAB_BARK.get())).test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (this.isInput(input) && this.isIngredient(ingredient)) {
            return PotionContents.createItemStack((Item)input.getItem(), (Holder)Potions.LONG_FIRE_RESISTANCE);
        }
        return ItemStack.EMPTY;
    }
}

