/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jaams.jaams_weaponry.dispenser.DynamiteDispenser;
import net.jaams.jaams_weaponry.dispenser.KunaiDispenser;
import net.jaams.jaams_weaponry.dispenser.SharpStoneDispenser;
import net.jaams.jaams_weaponry.dispenser.ShurikenDispenser;
import net.jaams.jaams_weaponry.dispenser.SmokeBombDispenser;
import net.jaams.jaams_weaponry.dispenser.StakeDispenser;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMenus;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModPaintings;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModSounds;
import net.jaams.jaams_weaponry.loot.LootModifiers;
import net.jaams.jaams_weaponry.packets.AberrationPacket;
import net.jaams.jaams_weaponry.packets.AmountPacket;
import net.jaams.jaams_weaponry.packets.AnimationPacket;
import net.jaams.jaams_weaponry.packets.DualWieldPacket;
import net.jaams.jaams_weaponry.packets.GunInventoryPacket;
import net.jaams.jaams_weaponry.packets.GunShootPacket;
import net.jaams.jaams_weaponry.packets.VisualRecoilPacket;
import net.jaams.jaams_weaponry.registries.BottomItems;
import net.jaams.jaams_weaponry.registries.CustomParticles;
import net.jaams.jaams_weaponry.registries.CustomRecipes;
import net.jaams.jaams_weaponry.registries.DiamondItems;
import net.jaams.jaams_weaponry.registries.EnderiumItems;
import net.jaams.jaams_weaponry.registries.FarmersDelightItems;
import net.jaams.jaams_weaponry.registries.GoldenItems;
import net.jaams.jaams_weaponry.registries.IronItems;
import net.jaams.jaams_weaponry.registries.NetheriteItems;
import net.jaams.jaams_weaponry.registries.RosegoldItems;
import net.jaams.jaams_weaponry.registries.RoyalItems;
import net.jaams.jaams_weaponry.registries.ShineriteItems;
import net.jaams.jaams_weaponry.registries.StoneItems;
import net.jaams.jaams_weaponry.registries.SupplementariesItems;
import net.jaams.jaams_weaponry.registries.TopItems;
import net.jaams.jaams_weaponry.registries.WoodItems;
import net.jaams.jaams_weaponry.util.ModTab;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jaams_weaponry")
public class JaamsWeaponryMod {
    public static final Logger LOGGER = LogManager.getLogger(JaamsWeaponryMod.class);
    public static final String MODID = "jaams_weaponry";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("jaams_weaponry", "jaams_weaponry"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public JaamsWeaponryMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        JaamsWeaponryModSounds.REGISTRY.register(bus);
        JaamsWeaponryModEntities.REGISTRY.register(bus);
        JaamsWeaponryModEnchantments.REGISTRY.register(bus);
        JaamsWeaponryModMobEffects.REGISTRY.register(bus);
        JaamsWeaponryModMenus.REGISTRY.register(bus);
        JaamsWeaponryModPaintings.REGISTRY.register(bus);
        TopItems.REGISTRY.register(bus);
        WoodItems.REGISTRY.register(bus);
        StoneItems.REGISTRY.register(bus);
        IronItems.REGISTRY.register(bus);
        GoldenItems.REGISTRY.register(bus);
        DiamondItems.REGISTRY.register(bus);
        NetheriteItems.REGISTRY.register(bus);
        if (ModList.get().isLoaded("cavesanddepths")) {
            RosegoldItems.REGISTRY.register(bus);
        }
        if (ModList.get().isLoaded("jaams_shinerite")) {
            ShineriteItems.REGISTRY.register(bus);
        }
        if (ModList.get().isLoaded("majruszsdifficulty")) {
            EnderiumItems.REGISTRY.register(bus);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmersDelightItems.REGISTRY.register(bus);
        }
        if (ModList.get().isLoaded("supplementaries")) {
            SupplementariesItems.REGISTRY.register(bus);
        }
        RoyalItems.REGISTRY.register(bus);
        BottomItems.REGISTRY.register(bus);
        ModTab.REGISTRY.register(bus);
        CustomRecipes.REGISTRY.register(bus);
        LootModifiers.register(bus);
        CustomParticles.register(bus);
        bus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JaamsWeaponryModItems.KUNAI.get()), (DispenseItemBehavior)new KunaiDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JaamsWeaponryModItems.SHURIKEN.get()), (DispenseItemBehavior)new ShurikenDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JaamsWeaponryModItems.STAKE.get()), (DispenseItemBehavior)new StakeDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JaamsWeaponryModItems.SHARP_STONE.get()), (DispenseItemBehavior)new SharpStoneDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JaamsWeaponryModItems.DYNAMITE.get()), (DispenseItemBehavior)new DynamiteDispenser());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)JaamsWeaponryModItems.SMOKE_BOMB.get()), (DispenseItemBehavior)new SmokeBombDispenser());
        JaamsWeaponryMod.addNetworkMessage(AmountPacket.class, AmountPacket::encode, AmountPacket::decode, AmountPacket::handle);
        JaamsWeaponryMod.addNetworkMessage(AnimationPacket.class, AnimationPacket::encode, AnimationPacket::decode, AnimationPacket::handle);
        JaamsWeaponryMod.addNetworkMessage(AberrationPacket.class, AberrationPacket::encode, AberrationPacket::decode, AberrationPacket::handle);
        JaamsWeaponryMod.addNetworkMessage(DualWieldPacket.class, DualWieldPacket::encode, DualWieldPacket::decode, DualWieldPacket::handle);
        JaamsWeaponryMod.addNetworkMessage(GunInventoryPacket.class, GunInventoryPacket::encode, GunInventoryPacket::decode, GunInventoryPacket::handle);
        JaamsWeaponryMod.addNetworkMessage(GunShootPacket.class, GunShootPacket::encode, GunShootPacket::decode, GunShootPacket::handle);
        JaamsWeaponryMod.addNetworkMessage(VisualRecoilPacket.class, VisualRecoilPacket::encode, VisualRecoilPacket::decode, VisualRecoilPacket::handle);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

