/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.mechanics;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.handler.mechanics.ItemSwitchHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.weapons.DaggerItem;
import net.jaams.jaams_weaponry.weapons.DaggerReverseItem;
import net.jaams.jaams_weaponry.weapons.SawCleaverItem;
import net.jaams.jaams_weaponry.weapons.SawCleaverUnfoldedItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ItemSwitchBehavior {
    private static final long SWITCH_BASE_COOLDOWN_MIN = 100L;
    private static final long SWITCH_BASE_COOLDOWN_MAX = 160L;
    private static final long INITIAL_SPAWN_COOLDOWN_MIN = 150L;
    private static final long INITIAL_SPAWN_COOLDOWN_MAX = 250L;
    private static final double BASE_SWITCH_PROBABILITY_MIN = 0.02;
    private static final double BASE_SWITCH_PROBABILITY_MAX = 0.08;
    private static final double PLAYER_PROXIMITY_RADIUS = 16.0;
    private static final Map<UUID, Long> LAST_SWITCH_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> ENTITY_SWITCH_COOLDOWN = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Double> ENTITY_BASE_SWITCH_PROBABILITY = new ConcurrentHashMap<UUID, Double>();

    @SubscribeEvent
    public static void onItemSwitchMobEntityUpdate(LivingEvent.LivingTickEvent event) {
        SoundEvent sound;
        Mob mob;
        LivingEntity entity;
        block22: {
            block21: {
                entity = event.getEntity();
                if (entity.m_9236_().m_5776_() || !entity.m_6084_() || !(entity instanceof Mob)) break block21;
                mob = (Mob)entity;
                if (!(entity instanceof Player) && !mob.m_21525_()) break block22;
            }
            return;
        }
        Level level = entity.m_9236_();
        ItemStack heldItem = entity.m_21205_();
        if (heldItem.m_41619_() || ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        if (!level.m_45976_(Player.class, entity.m_20191_().m_82400_(16.0)).stream().anyMatch(player -> player.m_6084_() && !player.m_5833_())) {
            return;
        }
        long currentTime = level.m_46467_();
        long switchCooldown = ENTITY_SWITCH_COOLDOWN.getOrDefault(entity.m_20148_(), 100L);
        double baseSwitchProbability = ENTITY_BASE_SWITCH_PROBABILITY.getOrDefault(entity.m_20148_(), 0.02);
        if (level.m_213780_().m_188500_() >= baseSwitchProbability || currentTime - LAST_SWITCH_TIME.getOrDefault(entity.m_20148_(), 0L) < switchCooldown) {
            return;
        }
        Item currentItem = heldItem.m_41720_();
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)currentItem);
        if (itemId == null || !itemId.m_135827_().equals("jaams_weaponry")) {
            return;
        }
        String path = itemId.m_135815_();
        Item targetItem = null;
        String soundEvent = null;
        List<ResourceLocation> noCooldownTags = null;
        List<Item> noCooldownItems = null;
        int mainHandCooldown = 20;
        int offHandCooldown = 20;
        if (currentItem instanceof DaggerItem && !path.endsWith("_reverse")) {
            targetPath = path + "_reverse";
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", (String)targetPath);
            targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            soundEvent = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
            noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:daggers"), new ResourceLocation("jaams_weaponry:reverse_daggers"));
        } else if (currentItem instanceof DaggerReverseItem && path.endsWith("_reverse")) {
            targetPath = path.substring(0, path.length() - "_reverse".length());
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", (String)targetPath);
            targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            soundEvent = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
            noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:daggers"), new ResourceLocation("jaams_weaponry:reverse_daggers"));
        } else if (currentItem instanceof SawCleaverItem && !path.endsWith("_unfolded")) {
            targetPath = path + "_unfolded";
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", (String)targetPath);
            targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            soundEvent = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
            noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:saw_cleavers"), new ResourceLocation("jaams_weaponry:saw_cleavers_unfolded"));
            mainHandCooldown = 30;
            offHandCooldown = 30;
        } else if (currentItem instanceof SawCleaverUnfoldedItem && path.endsWith("_unfolded")) {
            targetPath = path.substring(0, path.length() - "_unfolded".length());
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", (String)targetPath);
            targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            soundEvent = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
            noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:saw_cleavers"), new ResourceLocation("jaams_weaponry:saw_cleavers_unfolded"));
            mainHandCooldown = 30;
            offHandCooldown = 30;
        } else if (currentItem == JaamsWeaponryModItems.TESSEN.get()) {
            targetItem = (Item)JaamsWeaponryModItems.TESSEN_FOLDED.get();
            soundEvent = "jaams_weaponry:tessen_closed";
            noCooldownItems = Arrays.asList((Item)JaamsWeaponryModItems.TESSEN.get(), (Item)JaamsWeaponryModItems.TESSEN_FOLDED.get());
        } else if (currentItem == JaamsWeaponryModItems.TESSEN_FOLDED.get()) {
            targetItem = (Item)JaamsWeaponryModItems.TESSEN.get();
            soundEvent = "jaams_weaponry:tessen_open";
            noCooldownItems = Arrays.asList((Item)JaamsWeaponryModItems.TESSEN.get(), (Item)JaamsWeaponryModItems.TESSEN_FOLDED.get());
        } else {
            return;
        }
        if (targetItem == ItemStack.f_41583_.m_41720_()) {
            return;
        }
        ItemSwitchHandler.switchItem((LevelAccessor)level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, currentItem, targetItem, mainHandCooldown, offHandCooldown, soundEvent, noCooldownItems, noCooldownTags);
        if (soundEvent != null && (sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(soundEvent))) != null) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound, SoundSource.HOSTILE, 0.35f, 0.9f + level.m_213780_().m_188501_() * 0.2f);
        }
        entity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)targetItem, heldItem.m_41613_()));
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_7654_().m_6937_((Runnable)new TickTask(2, () -> mob.m_21573_().m_26573_()));
        LAST_SWITCH_TIME.put(entity.m_20148_(), currentTime);
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Mob && !(event.getEntity() instanceof Player)) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            RandomSource random = event.getLevel().m_213780_();
            long switchCooldown = 100L + (long)(random.m_188500_() * 60.0);
            long initialCooldown = 150L + (long)(random.m_188500_() * 100.0);
            double baseSwitchProbability = 0.02 + random.m_188500_() * 0.06;
            ENTITY_SWITCH_COOLDOWN.put(entity.m_20148_(), switchCooldown);
            ENTITY_BASE_SWITCH_PROBABILITY.put(entity.m_20148_(), baseSwitchProbability);
            LAST_SWITCH_TIME.put(entity.m_20148_(), event.getLevel().m_46467_() - switchCooldown + initialCooldown);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            LAST_SWITCH_TIME.remove(entity.m_20148_());
            ENTITY_SWITCH_COOLDOWN.remove(entity.m_20148_());
            ENTITY_BASE_SWITCH_PROBABILITY.remove(entity.m_20148_());
        }
    }
}

